/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.AbstractLocationConfigSourceLoader;
import io.smallrye.config.EnvConfigSource;
import io.smallrye.config.common.utils.ConfigSourceUtil;
import io.smallrye.config.common.utils.StringUtil;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;

public class DotEnvConfigSourceProvider
extends AbstractLocationConfigSourceLoader
implements ConfigSourceProvider {
    private final String location;

    public DotEnvConfigSourceProvider() {
        this(Paths.get(System.getProperty("user.dir"), ".env").toUri().toString());
    }

    public DotEnvConfigSourceProvider(String location) {
        this.location = location;
    }

    @Override
    protected String[] getFileExtensions() {
        return new String[]{""};
    }

    @Override
    protected ConfigSource loadConfigSource(final URL url, int ordinal) throws IOException {
        HashMap<String, String> envProperties = new HashMap<String, String>();
        for (Map.Entry entry : ConfigSourceUtil.urlToMap((URL)url).entrySet()) {
            envProperties.put(StringUtil.replaceNonAlphanumericByUnderscores((String)((String)entry.getKey())), (String)entry.getValue());
        }
        return new EnvConfigSource(envProperties, ordinal){

            public String getName() {
                return super.getName() + "[source=" + url + "]";
            }
        };
    }

    public List<ConfigSource> getConfigSources(ClassLoader forClassLoader) {
        return this.loadConfigSources(this.location, 295, forClassLoader);
    }

    public static List<ConfigSource> dotEnvSources(ClassLoader classLoader) {
        return new DotEnvConfigSourceProvider().getConfigSources(classLoader);
    }

    public static List<ConfigSource> dotEnvSources(String location, ClassLoader classLoader) {
        return new DotEnvConfigSourceProvider(location).getConfigSources(classLoader);
    }
}

