package io.vertx.mutiny.core.http;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;

/**
 * Represents an file upload from an HTML FORM.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.HttpServerFileUpload original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.http.HttpServerFileUpload.class)
public class HttpServerFileUpload implements io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.buffer.Buffer> {

  public static final io.smallrye.mutiny.vertx.TypeArg<HttpServerFileUpload> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new HttpServerFileUpload((io.vertx.core.http.HttpServerFileUpload) obj),
    HttpServerFileUpload::getDelegate
  );

  private final io.vertx.core.http.HttpServerFileUpload delegate;
  
  public HttpServerFileUpload(io.vertx.core.http.HttpServerFileUpload delegate) {
    this.delegate = delegate;
  }

  public HttpServerFileUpload(Object delegate) {
    this.delegate = (io.vertx.core.http.HttpServerFileUpload)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  HttpServerFileUpload() {
    this.delegate = null;
  }

  public io.vertx.core.http.HttpServerFileUpload getDelegate() {
    return delegate;
  }

  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_0 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HttpServerFileUpload that = (HttpServerFileUpload) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return a pipe
   */
  public io.vertx.mutiny.core.streams.Pipe<io.vertx.mutiny.core.buffer.Buffer> pipe() { 
    io.vertx.mutiny.core.streams.Pipe<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), TYPE_ARG_0);
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param dst the destination write stream
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> pipeTo(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> dst) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.pipeTo(dst.getDelegate(), handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param dst the destination write stream
   * @return the Void instance produced by the operation.
   */
  public Void pipeToAndAwait(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> dst) { 
    return (Void) pipeTo(dst).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream)} but you don't need to compose it with other operations.
   * @param dst the destination write stream
   */
  public void pipeToAndForget(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> dst) { 
    pipeTo(dst).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  @Fluent
  private io.vertx.mutiny.core.http.HttpServerFileUpload __exceptionHandler(Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.mutiny.core.http.HttpServerFileUpload exceptionHandler(java.util.function.Consumer<java.lang.Throwable> handler) {
    return __exceptionHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  @Fluent
  private io.vertx.mutiny.core.http.HttpServerFileUpload __handler(Handler<io.vertx.mutiny.core.buffer.Buffer> handler) { 
    delegate.handler(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, event -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)event)));
    return this;
  }

  public io.vertx.mutiny.core.http.HttpServerFileUpload handler(java.util.function.Consumer<io.vertx.mutiny.core.buffer.Buffer> handler) {
    return __handler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  @Fluent
  private io.vertx.mutiny.core.http.HttpServerFileUpload __endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  public io.vertx.mutiny.core.http.HttpServerFileUpload endHandler(java.lang.Runnable endHandler) {
    return __endHandler(ignored -> endHandler.run()
);
  }

  @Fluent
  public io.vertx.mutiny.core.http.HttpServerFileUpload pause() { 
    delegate.pause();
    return this;
  }

  @Fluent
  public io.vertx.mutiny.core.http.HttpServerFileUpload resume() { 
    delegate.resume();
    return this;
  }

  @Fluent
  public io.vertx.mutiny.core.http.HttpServerFileUpload fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  /**
   * Stream the content of this upload to the given file on storage.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param filename the name of the file
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> streamToFileSystem(String filename) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.streamToFileSystem(filename, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpServerFileUpload#streamToFileSystem(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param filename the name of the file
   * @return the Void instance produced by the operation.
   */
  public Void streamToFileSystemAndAwait(String filename) { 
    return (Void) streamToFileSystem(filename).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.HttpServerFileUpload#streamToFileSystem(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.HttpServerFileUpload#streamToFileSystem(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.HttpServerFileUpload#streamToFileSystem(String)} but you don't need to compose it with other operations.
   * @param filename the name of the file
   */
  public void streamToFileSystemAndForget(String filename) { 
    streamToFileSystem(filename).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * @return <code>true</code> when the stream is cancelled, otherwise it means that stream is finished
   */
  public boolean cancelStreamToFileSystem() { 
    boolean ret = delegate.cancelStreamToFileSystem();
    return ret;
  }

  /**
   * @return the filename which was used when upload the file.
   */
  public String filename() { 
    String ret = delegate.filename();
    return ret;
  }

  /**
   * @return the name of the attribute
   */
  public String name() { 
    String ret = delegate.name();
    return ret;
  }

  /**
   * @return the content type for the upload
   */
  public String contentType() { 
    String ret = delegate.contentType();
    return ret;
  }

  /**
   * @return the contentTransferEncoding for the upload
   */
  public String contentTransferEncoding() { 
    String ret = delegate.contentTransferEncoding();
    return ret;
  }

  /**
   * @return the charset for the upload
   */
  public String charset() { 
    String ret = delegate.charset();
    return ret;
  }

  /**
   * @return the size of the upload (in bytes)
   */
  public long size() { 
    long ret = delegate.size();
    return ret;
  }

  /**
   * @return <code>true</code> if the size of the upload can be retrieved via {@link io.vertx.mutiny.core.http.HttpServerFileUpload#size}.
   */
  public boolean isSizeAvailable() { 
    boolean ret = delegate.isSizeAvailable();
    return ret;
  }

  /**
   * @return the async uploaded file when {@link io.vertx.mutiny.core.http.HttpServerFileUpload#streamToFileSystem} has been used and the file is available
   */
  public io.vertx.mutiny.core.file.AsyncFile file() { 
    io.vertx.mutiny.core.file.AsyncFile ret = io.vertx.mutiny.core.file.AsyncFile.newInstance((io.vertx.core.file.AsyncFile)delegate.file());
    return ret;
  }

  private Multi<io.vertx.mutiny.core.buffer.Buffer> multi;

  @CheckReturnValue
  public synchronized Multi<io.vertx.mutiny.core.buffer.Buffer> toMulti() {
    if (multi == null) {
      java.util.function.Function<io.vertx.core.buffer.Buffer, io.vertx.mutiny.core.buffer.Buffer> conv = io.vertx.mutiny.core.buffer.Buffer::newInstance;
      multi = io.smallrye.mutiny.vertx.MultiHelper.toMulti(delegate, conv);    }
    return multi;
  }

  public java.lang.Iterable<io.vertx.mutiny.core.buffer.Buffer> toBlockingIterable() {
    return toMulti().subscribe().asIterable();
  }

  public java.util.stream.Stream<io.vertx.mutiny.core.buffer.Buffer> toBlockingStream() {
    return toMulti().subscribe().asStream();
  }

  public static  HttpServerFileUpload newInstance(io.vertx.core.http.HttpServerFileUpload arg) {
    return arg != null ? new HttpServerFileUpload(arg) : null;
  }

}
