/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.cdi.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import io.smallrye.graphql.api.Context;
import io.smallrye.graphql.cdi.metrics.MetricMeasurement;
import io.smallrye.graphql.spi.MetricsService;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.logging.Logger;

public class MicrometerMetricsService
implements MetricsService {
    private final MeterRegistry meterRegistry = Metrics.globalRegistry;
    private final Map<Long, MetricMeasurement> metricsMemory = new ConcurrentHashMap<Long, MetricMeasurement>();
    private static final String METRIC_NAME = "mp_graphql";
    private Logger LOG = Logger.getLogger(MicrometerMetricsService.class);

    public MicrometerMetricsService() {
        this.meterRegistry.getMeters();
    }

    private Tags getTags(MetricMeasurement metricMeasurement) {
        return Tags.of((String)"name", (String)metricMeasurement.getName()).and("type", metricMeasurement.getOperationType()).and("source", String.valueOf(metricMeasurement.isSource()));
    }

    public void start(Long measurementId, Context context) {
        this.metricsMemory.put(measurementId, new MetricMeasurement(context.getFieldName(), context.hasSource(), context.getOperationType(), System.nanoTime()));
        this.LOG.tracef("(" + measurementId + ") Started recording metrics for: %s", (Object)context.getFieldName());
    }

    public void end(Long measurementId) {
        MetricMeasurement metricMeasurement = this.metricsMemory.remove(measurementId);
        long duration = System.nanoTime() - metricMeasurement.getTimeStarted();
        this.meterRegistry.timer(METRIC_NAME, (Iterable)this.getTags(metricMeasurement)).record(Duration.ofNanos(duration));
        this.LOG.tracef("(" + measurementId + ") Finished recording metrics for: %s", (Object)metricMeasurement.getName());
    }
}

