/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.build.impl;

import io.smallrye.jwt.build.JwtEncryptionException;
import io.smallrye.jwt.build.JwtException;
import io.smallrye.jwt.build.JwtSignatureException;
import io.smallrye.jwt.build.impl.ImplMessages;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;

public class ImplMessages_$bundle
implements ImplMessages,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final ImplMessages_$bundle INSTANCE = new ImplMessages_$bundle();
    private static final Locale LOCALE = Locale.ROOT;

    protected ImplMessages_$bundle() {
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String unsupportedSignatureAlgorithm$str() {
        return "SRJWT05000: Unsupported signature algorithm: %s";
    }

    @Override
    public final JwtSignatureException unsupportedSignatureAlgorithm(String algorithmName, Throwable throwable) {
        JwtSignatureException result = new JwtSignatureException(String.format(this.getLoggingLocale(), this.unsupportedSignatureAlgorithm$str(), algorithmName), throwable);
        ImplMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    @Override
    public final JwtSignatureException unsupportedSignatureAlgorithm(String algorithmName) {
        JwtSignatureException result = new JwtSignatureException(String.format(this.getLoggingLocale(), this.unsupportedSignatureAlgorithm$str(), algorithmName));
        ImplMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String joseSerializationError$str() {
        return "SRJWT05003: %s";
    }

    @Override
    public final JwtEncryptionException joseSerializationError(String errorMessage, Throwable t) {
        JwtEncryptionException result = new JwtEncryptionException(String.format(this.getLoggingLocale(), this.joseSerializationError$str(), errorMessage), t);
        ImplMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String directContentEncryptionUnsupported$str() {
        return "SRJWT05004: Direct content encryption is currently not supported";
    }

    @Override
    public final JwtEncryptionException directContentEncryptionUnsupported() {
        JwtEncryptionException result = new JwtEncryptionException(String.format(this.getLoggingLocale(), this.directContentEncryptionUnsupported$str(), new Object[0]));
        ImplMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unsupportedKeyEncryptionAlgorithm$str() {
        return "SRJWT05005: Unsupported key encryption algorithm: %s";
    }

    @Override
    public final JwtEncryptionException unsupportedKeyEncryptionAlgorithm(String algorithmName) {
        JwtEncryptionException result = new JwtEncryptionException(String.format(this.getLoggingLocale(), this.unsupportedKeyEncryptionAlgorithm$str(), algorithmName));
        ImplMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unsupportedContentEncryptionAlgorithm$str() {
        return "SRJWT05006: Unsupported content encryption algorithm: %s";
    }

    @Override
    public final JwtEncryptionException unsupportedContentEncryptionAlgorithm(String algorithmName) {
        JwtEncryptionException result = new JwtEncryptionException(String.format(this.getLoggingLocale(), this.unsupportedContentEncryptionAlgorithm$str(), algorithmName));
        ImplMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String encryptionKeyCanNotBeLoadedFromLocation$str() {
        return "SRJWT05007: Key encryption key can not be loaded from: %s";
    }

    @Override
    public final IllegalArgumentException encryptionKeyCanNotBeLoadedFromLocation(String keyLocation) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.encryptionKeyCanNotBeLoadedFromLocation$str(), keyLocation));
        ImplMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String encryptionKeyNotConfigured$str() {
        return "SRJWT05008: Please set 'smallrye.jwt.encrypt.key.location' or 'smallrye.jwt.encrypt.key' property";
    }

    @Override
    public final IllegalArgumentException encryptionKeyNotConfigured() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.encryptionKeyNotConfigured$str(), new Object[0]));
        ImplMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String signatureException$str() {
        return "SRJWT05009: ";
    }

    @Override
    public final JwtSignatureException signatureException(Throwable throwable) {
        JwtSignatureException result = new JwtSignatureException(String.format(this.getLoggingLocale(), this.signatureException$str(), new Object[0]), throwable);
        ImplMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String signKeyPropertyRequired$str() {
        return "SRJWT05010: Inner JWT can not be created, 'smallrye.jwt.sign.key.location' is not set but the 'alg' header is: %s";
    }

    @Override
    public final JwtSignatureException signKeyPropertyRequired(String algorithmName) {
        JwtSignatureException result = new JwtSignatureException(String.format(this.getLoggingLocale(), this.signKeyPropertyRequired$str(), algorithmName));
        ImplMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noneSignatureAlgorithmUnsupported$str() {
        return "SRJWT05011: None signature algorithm is currently not supported";
    }

    @Override
    public final JwtSignatureException noneSignatureAlgorithmUnsupported() {
        JwtSignatureException result = new JwtSignatureException(String.format(this.getLoggingLocale(), this.noneSignatureAlgorithmUnsupported$str(), new Object[0]));
        ImplMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String signJwtTokenFailed$str() {
        return "SRJWT05012: Failure to create a signed JWT token: %s";
    }

    @Override
    public final JwtSignatureException signJwtTokenFailed(String exceptionMessage, Throwable throwable) {
        JwtSignatureException result = new JwtSignatureException(String.format(this.getLoggingLocale(), this.signJwtTokenFailed$str(), exceptionMessage), throwable);
        ImplMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String algDoesNotMatchKeyType$str() {
        return "SRJWT05013: JWK algorithm 'alg' value does not match a key type";
    }

    @Override
    public final IllegalArgumentException algDoesNotMatchKeyType() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.algDoesNotMatchKeyType$str(), new Object[0]));
        ImplMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String publicKeyBeingUsedForSign$str() {
        return "SRJWT05014: Only PrivateKey or SecretKey can be be used to sign a token";
    }

    @Override
    public final IllegalArgumentException publicKeyBeingUsedForSign() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.publicKeyBeingUsedForSign$str(), new Object[0]));
        ImplMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String readJsonFailure$str() {
        return "SRJWT05015: Failure to read the json content: %s";
    }

    @Override
    public final JwtException readJsonFailure(String exceptionMessage, Throwable throwable) {
        JwtException result = new JwtException(String.format(this.getLoggingLocale(), this.readJsonFailure$str(), exceptionMessage), throwable);
        ImplMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failureToParseJWK$str() {
        return "SRJWT05016: Failure to parse JWK: %s";
    }

    @Override
    public final JwtException failureToParseJWK(String exceptionMessage, Throwable throwable) {
        JwtException result = new JwtException(String.format(this.getLoggingLocale(), this.failureToParseJWK$str(), exceptionMessage), throwable);
        ImplMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failureToParseJWKS$str() {
        return "SRJWT05017: Failure to parse JWK Set: %s";
    }

    @Override
    public final JwtException failureToParseJWKS(String exceptionMessage, Throwable throwable) {
        JwtException result = new JwtException(String.format(this.getLoggingLocale(), this.failureToParseJWKS$str(), exceptionMessage), throwable);
        ImplMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String kidRequired$str() {
        return "SRJWT05018: Key id 'kid' header value must be provided";
    }

    @Override
    public final IllegalArgumentException kidRequired() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.kidRequired$str(), new Object[0]));
        ImplMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String keyWithKidNotFound$str() {
        return "SRJWT05019: JWK set has no key with a key id 'kid' header '%s'";
    }

    @Override
    public final IllegalArgumentException keyWithKidNotFound(String keyId) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.keyWithKidNotFound$str(), keyId));
        ImplMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String signingKeyCanNotBeLoadedFromLocation$str() {
        return "SRJWT05020: Signing key can not be loaded from: %s";
    }

    @Override
    public final IllegalArgumentException signingKeyCanNotBeLoadedFromLocation(String keyLocation) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.signingKeyCanNotBeLoadedFromLocation$str(), keyLocation));
        ImplMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String signKeyNotConfigured$str() {
        return "SRJWT05021: Please set 'smallrye.jwt.sign.key.location' or 'smallrye.jwt.sign.key' property";
    }

    @Override
    public final IllegalArgumentException signKeyNotConfigured() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.signKeyNotConfigured$str(), new Object[0]));
        ImplMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failureToParseJWTClaims$str() {
        return "SRJWT05022: Failure to parse the JWT claims: %s";
    }

    @Override
    public final JwtException failureToParseJWTClaims(String exceptionMessage, Throwable throwable) {
        JwtException result = new JwtException(String.format(this.getLoggingLocale(), this.failureToParseJWTClaims$str(), exceptionMessage), throwable);
        ImplMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failureToReadPrivateKey$str() {
        return "SRJWT05024: Failure to read the private key: %s";
    }

    @Override
    public final JwtException failureToReadPrivateKey(String exceptionMessage, Throwable throwable) {
        JwtException result = new JwtException(String.format(this.getLoggingLocale(), this.failureToReadPrivateKey$str(), exceptionMessage), throwable);
        ImplMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failureToOpenInputStreamFromJsonResName$str() {
        return "SRJWT05025: Failure to open the input stream from %s";
    }

    @Override
    public final JwtException failureToOpenInputStreamFromJsonResName(String jsonResName) {
        JwtException result = new JwtException(String.format(this.getLoggingLocale(), this.failureToOpenInputStreamFromJsonResName$str(), jsonResName));
        ImplMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failureToReadJsonContentFromJsonResName$str() {
        return "SRJWT05026: Failure to read the json content from %s: %s";
    }

    @Override
    public final JwtException failureToReadJsonContentFromJsonResName(String jsonResName, String exceptionMessage, Throwable throwable) {
        JwtException result = new JwtException(String.format(this.getLoggingLocale(), this.failureToReadJsonContentFromJsonResName$str(), jsonResName, exceptionMessage), throwable);
        ImplMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String encryptionException$str() {
        return "SRJWT05027: Failure to encrypt the token";
    }

    @Override
    public final JwtEncryptionException encryptionException(Throwable throwable) {
        JwtEncryptionException result = new JwtEncryptionException(String.format(this.getLoggingLocale(), this.encryptionException$str(), new Object[0]), throwable);
        ImplMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String signingKeyCanNotBeCreatedFromContent$str() {
        return "SRJWT05028: Signing key can not be created from the loaded content";
    }

    @Override
    public final IllegalArgumentException signingKeyCanNotBeCreatedFromContent() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.signingKeyCanNotBeCreatedFromContent$str(), new Object[0]));
        ImplMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String encryptionKeyCanNotBeCreatedFromContent$str() {
        return "SRJWT05029: Encryption key can not be created from the loaded content";
    }

    @Override
    public final IllegalArgumentException encryptionKeyCanNotBeCreatedFromContent() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.encryptionKeyCanNotBeCreatedFromContent$str(), new Object[0]));
        ImplMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String signingKeyCanNotBeReadFromKeystore$str() {
        return "SRJWT05030: Signing key can not be read from the keystore";
    }

    @Override
    public final IllegalArgumentException signingKeyCanNotBeReadFromKeystore(Throwable throwable) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.signingKeyCanNotBeReadFromKeystore$str(), new Object[0]), throwable);
        ImplMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String encryptionKeyCanNotBeReadFromKeystore$str() {
        return "SRJWT05031: Encryption key can not be read from the keystore";
    }

    @Override
    public final IllegalArgumentException encryptionKeyCanNotBeReadFromKeystore(Throwable throwable) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.encryptionKeyCanNotBeReadFromKeystore$str(), new Object[0]), throwable);
        ImplMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }
}

