/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import springfox.documentation.schema.ModelKey;
import springfox.documentation.schema.PropertySpecification;
import springfox.documentation.schema.ReferenceModelSpecification;

public class CompoundModelSpecification {
    private final ModelKey modelKey;
    private final List<PropertySpecification> properties;
    private final Integer maxProperties;
    private final Integer minProperties;
    private final String discriminator;
    private final List<ReferenceModelSpecification> subclassReferences;

    public CompoundModelSpecification(ModelKey modelKey, Collection<PropertySpecification> properties, Integer maxProperties, Integer minProperties, String discriminator, List<ReferenceModelSpecification> subclassReferences) {
        this.modelKey = modelKey;
        this.properties = new ArrayList<PropertySpecification>(properties);
        this.maxProperties = maxProperties;
        this.minProperties = minProperties;
        this.discriminator = discriminator;
        this.subclassReferences = subclassReferences;
    }

    public ModelKey getModelKey() {
        return this.modelKey;
    }

    public Collection<PropertySpecification> getProperties() {
        return this.properties;
    }

    public Integer getMaxProperties() {
        return this.maxProperties;
    }

    public Integer getMinProperties() {
        return this.minProperties;
    }

    public Collection<ReferenceModelSpecification> getSubclassReferences() {
        return this.subclassReferences;
    }

    public String getDiscriminator() {
        return this.discriminator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompoundModelSpecification that = (CompoundModelSpecification)o;
        return Objects.equals(this.modelKey, that.modelKey) && Objects.equals(this.properties, that.properties) && Objects.equals(this.maxProperties, that.maxProperties) && Objects.equals(this.minProperties, that.minProperties) && Objects.equals(this.discriminator, that.discriminator) && Objects.equals(this.subclassReferences, that.subclassReferences);
    }

    public int hashCode() {
        return Objects.hash(this.modelKey, this.properties, this.maxProperties, this.minProperties, this.discriminator, this.subclassReferences);
    }

    public String toString() {
        return "CompoundModelSpecification{modelKey=" + this.modelKey + ", properties=" + this.properties + ", maxProperties=" + this.maxProperties + ", minProperties=" + this.minProperties + ", discriminator='" + this.discriminator + '\'' + ", subclassReferences=" + this.subclassReferences + '}';
    }
}

