/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CodegenParameter;
import io.swagger.codegen.SupportingFile;
import io.swagger.codegen.languages.AbstractTypeScriptClientCodegen;
import io.swagger.models.properties.Property;
import java.io.File;

public class TypeScriptAngularClientCodegen
extends AbstractTypeScriptClientCodegen {
    @Override
    public String getName() {
        return "typescript-angular";
    }

    @Override
    public String getHelp() {
        return "Generates a TypeScript AngularJS client library.";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.supportingFiles.add(new SupportingFile("models.mustache", this.modelPackage().replace('.', File.separatorChar), "models.ts"));
        this.supportingFiles.add(new SupportingFile("apis.mustache", this.apiPackage().replace('.', File.separatorChar), "api.ts"));
        this.supportingFiles.add(new SupportingFile("index.mustache", this.getIndexDirectory(), "index.ts"));
        this.supportingFiles.add(new SupportingFile("api.module.mustache", this.getIndexDirectory(), "api.module.ts"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("gitignore", "", ".gitignore"));
    }

    public TypeScriptAngularClientCodegen() {
        this.outputFolder = "generated-code/typescript-angular";
        this.modelTemplateFiles.put("model.mustache", ".ts");
        this.apiTemplateFiles.put("api.mustache", ".ts");
        this.templateDir = "typescript-angular";
        this.embeddedTemplateDir = "typescript-angular";
        this.apiPackage = "api";
        this.modelPackage = "model";
    }

    @Override
    public String getSwaggerType(Property p) {
        String swaggerType = super.getSwaggerType(p);
        if (this.isLanguagePrimitive(swaggerType) || this.isLanguageGenericType(swaggerType)) {
            return swaggerType;
        }
        return this.addModelPrefix(swaggerType);
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
        super.postProcessParameter(parameter);
        parameter.dataType = this.addModelPrefix(parameter.dataType);
    }

    private String getIndexDirectory() {
        String indexPackage = this.modelPackage.substring(0, Math.max(0, this.modelPackage.lastIndexOf(46)));
        return indexPackage.replace('.', File.separatorChar);
    }

    private String addModelPrefix(String swaggerType) {
        String type = null;
        type = this.typeMapping.containsKey(swaggerType) ? (String)this.typeMapping.get(swaggerType) : swaggerType;
        if (!this.isLanguagePrimitive(type) && !this.isLanguageGenericType(type)) {
            type = "models." + swaggerType;
        }
        return type;
    }

    private boolean isLanguagePrimitive(String type) {
        return this.languageSpecificPrimitives.contains(type);
    }

    private boolean isLanguageGenericType(String type) {
        for (String genericType : this.languageGenericTypes) {
            if (!type.startsWith(genericType + "<")) continue;
            return true;
        }
        return false;
    }
}

