/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.impl.http;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;

public final class SimpleHttpResponse {
    private final int statusCode;
    private final MultiMap headers;
    private final Buffer body;

    public SimpleHttpResponse(int statusCode, MultiMap headers, Buffer body) {
        this.headers = headers;
        this.body = body;
        this.statusCode = statusCode;
    }

    public int statusCode() {
        return this.statusCode;
    }

    public MultiMap headers() {
        return this.headers;
    }

    public String getHeader(String header) {
        if (this.headers != null) {
            return this.headers.get(header);
        }
        return null;
    }

    public Buffer body() {
        return this.body;
    }

    public @Nullable JsonObject jsonObject() {
        return new JsonObject(this.body);
    }

    public @Nullable JsonArray jsonArray() {
        return new JsonArray(this.body);
    }

    public boolean is(String contentType) {
        String header;
        if (this.headers != null && (header = this.headers.get("Content-Type")) != null) {
            int sep = header.indexOf(59);
            if (sep != -1) {
                header = header.substring(0, sep).trim();
            }
            return contentType.equalsIgnoreCase(header);
        }
        return false;
    }
}

