/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.file.impl;

import io.vertx.core.file.impl.FileSystemImpl;
import io.vertx.core.impl.Utils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;
import java.util.UUID;

class FileCache {
    private Thread shutdownHook;
    private File cacheDir;

    static FileCache setupCache(String fileCacheDir) {
        FileCache cache = new FileCache(FileCache.setupCacheDir(fileCacheDir));
        cache.registerShutdownHook();
        return cache;
    }

    static File setupCacheDir(String fileCacheDir) {
        if (fileCacheDir.endsWith(File.separator)) {
            fileCacheDir = fileCacheDir.substring(0, fileCacheDir.length() - File.separator.length());
        }
        String cacheDirName = fileCacheDir + "-" + UUID.randomUUID().toString();
        File cacheDir = new File(cacheDirName);
        try {
            if (Utils.isWindows()) {
                Files.createDirectories(cacheDir.toPath(), new FileAttribute[0]);
            } else {
                Set<PosixFilePermission> perms = PosixFilePermissions.fromString("rwx------");
                Files.createDirectories(cacheDir.toPath(), PosixFilePermissions.asFileAttribute(perms));
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create cache dir: " + cacheDirName, e);
        }
        return cacheDir;
    }

    public FileCache(File cacheDir) {
        this.cacheDir = cacheDir;
    }

    synchronized void registerShutdownHook() {
        Thread shutdownHook;
        this.shutdownHook = shutdownHook = new Thread(this::runHook);
        Runtime.getRuntime().addShutdownHook(shutdownHook);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runHook() {
        FileCache fileCache = this;
        synchronized (fileCache) {
            if (this.cacheDir == null) {
                return;
            }
        }
        Thread deleteCacheDirThread = new Thread(() -> {
            try {
                this.deleteCacheDir();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        deleteCacheDirThread.start();
        try {
            deleteCacheDirThread.join(10000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() throws IOException {
        Thread hook;
        FileCache fileCache = this;
        synchronized (fileCache) {
            hook = this.shutdownHook;
            this.shutdownHook = null;
        }
        if (hook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(hook);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        this.deleteCacheDir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteCacheDir() throws IOException {
        File dir;
        FileCache fileCache = this;
        synchronized (fileCache) {
            if (this.cacheDir == null) {
                return;
            }
            dir = this.cacheDir;
            this.cacheDir = null;
        }
        if (dir.exists()) {
            FileSystemImpl.delete(dir.toPath(), true);
        }
    }

    File getFile(String fileName) {
        if (this.cacheDir == null) {
            throw new IllegalStateException("cacheDir is null");
        }
        return new File(this.cacheDir, fileName);
    }

    File cache(String fileName, File resource, boolean overwrite) throws IOException {
        File cacheFile = new File(this.cacheDir, fileName);
        boolean isDirectory = resource.isDirectory();
        if (!isDirectory) {
            cacheFile.getParentFile().mkdirs();
            if (!overwrite) {
                try {
                    Files.copy(resource.toPath(), cacheFile.toPath(), new CopyOption[0]);
                }
                catch (FileAlreadyExistsException fileAlreadyExistsException) {}
            } else {
                Files.copy(resource.toPath(), cacheFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        } else {
            cacheFile.mkdirs();
        }
        return cacheFile;
    }

    void cacheFile(String fileName, InputStream is, boolean overwrite) throws IOException {
        File cacheFile = new File(this.cacheDir, fileName);
        cacheFile.getParentFile().mkdirs();
        if (!overwrite) {
            try {
                Files.copy(is, cacheFile.toPath(), new CopyOption[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {}
        } else {
            Files.copy(is, cacheFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    void cacheDir(String fileName) {
        File file = new File(this.cacheDir, fileName);
        file.mkdirs();
    }
}

