/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.redis.client.RedisConnectOptions;
import io.vertx.redis.client.RedisConnectOptionsConverter;
import io.vertx.redis.client.RedisOptions;
import io.vertx.redis.client.RedisRole;
import io.vertx.redis.client.RedisSentinelConnectOptionsConverter;
import java.util.List;
import java.util.Map;

@DataObject(generateConverter=true)
public class RedisSentinelConnectOptions
extends RedisConnectOptions {
    private RedisRole role;
    private String masterName;

    public RedisSentinelConnectOptions(RedisOptions options) {
        super(options);
        this.setRole(options.getRole());
        this.setMasterName(options.getMasterName());
    }

    public RedisSentinelConnectOptions() {
        this.role = RedisRole.MASTER;
        this.masterName = "mymaster";
    }

    public RedisSentinelConnectOptions(RedisSentinelConnectOptions other) {
        this.role = other.role;
        this.masterName = other.masterName;
    }

    public RedisSentinelConnectOptions(JsonObject json) {
        this();
        RedisConnectOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public RedisRole getRole() {
        return this.role;
    }

    public RedisConnectOptions setRole(RedisRole role) {
        this.role = role;
        return this;
    }

    public String getMasterName() {
        return this.masterName;
    }

    public RedisConnectOptions setMasterName(String masterName) {
        this.masterName = masterName;
        return this;
    }

    @Override
    public RedisSentinelConnectOptions setMaxNestedArrays(int maxNestedArrays) {
        return (RedisSentinelConnectOptions)super.setMaxNestedArrays(maxNestedArrays);
    }

    @Override
    public RedisSentinelConnectOptions setProtocolNegotiation(boolean protocolNegotiation) {
        return (RedisSentinelConnectOptions)super.setProtocolNegotiation(protocolNegotiation);
    }

    @Override
    public RedisSentinelConnectOptions setPassword(String password) {
        return (RedisSentinelConnectOptions)super.setPassword(password);
    }

    @Override
    public RedisSentinelConnectOptions setEndpoints(List<String> endpoints) {
        return (RedisSentinelConnectOptions)super.setEndpoints(endpoints);
    }

    @Override
    public RedisSentinelConnectOptions setConnectionString(String connectionString) {
        return (RedisSentinelConnectOptions)super.setConnectionString(connectionString);
    }

    @Override
    public RedisSentinelConnectOptions setMaxWaitingHandlers(int maxWaitingHandlers) {
        return (RedisSentinelConnectOptions)super.setMaxWaitingHandlers(maxWaitingHandlers);
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = super.toJson();
        RedisSentinelConnectOptionsConverter.toJson(this, json);
        return json;
    }
}

