/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import io.vertx.redis.client.impl.PooledRedisConnection;
import java.util.List;

public class RedisSentinelConnection
implements RedisConnection {
    private final PooledRedisConnection connection;
    private final PooledRedisConnection sentinel;

    public RedisSentinelConnection(PooledRedisConnection connection, PooledRedisConnection sentinel) {
        this.connection = connection;
        this.sentinel = sentinel;
    }

    @Override
    public RedisConnection exceptionHandler(Handler<Throwable> handler) {
        this.connection.exceptionHandler((Handler)handler);
        return this;
    }

    @Override
    public RedisConnection handler(Handler<Response> handler) {
        this.connection.handler((Handler)handler);
        return this;
    }

    @Override
    public RedisConnection pause() {
        this.connection.pause();
        return this;
    }

    @Override
    public RedisConnection resume() {
        this.connection.resume();
        return this;
    }

    @Override
    public RedisConnection fetch(long amount) {
        this.connection.fetch(amount);
        return this;
    }

    @Override
    public RedisConnection endHandler(@Nullable Handler<Void> endHandler) {
        this.connection.endHandler((Handler)endHandler);
        return this;
    }

    @Override
    public Future<@Nullable Response> send(Request command) {
        return this.connection.send(command);
    }

    @Override
    public Future<List<@Nullable Response>> batch(List<Request> commands) {
        return this.connection.batch(commands);
    }

    @Override
    public Future<Void> close() {
        return this.sentinel.close().compose(done -> this.connection.close());
    }

    @Override
    public boolean pendingQueueFull() {
        return this.connection.pendingQueueFull();
    }
}

