/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl.types;

import io.vertx.core.buffer.Buffer;
import io.vertx.redis.client.Response;
import io.vertx.redis.client.ResponseType;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class BulkType
implements Response {
    public static final BulkType EMPTY = new BulkType(Buffer.buffer((String)""), false);
    private final Buffer message;
    private final String format;

    public static BulkType create(Buffer message, boolean verbatim) {
        return new BulkType(message, verbatim);
    }

    private BulkType(Buffer message, boolean verbatim) {
        if (verbatim) {
            this.format = message.getString(0, 3);
            assert (message.getByte(3) == 58);
            this.message = message.slice(4, message.length());
        } else {
            this.format = null;
            this.message = message;
        }
    }

    @Override
    public String format() {
        return this.format;
    }

    @Override
    public ResponseType type() {
        return ResponseType.BULK;
    }

    @Override
    public String toString() {
        return this.toString(StandardCharsets.UTF_8);
    }

    @Override
    public String toString(Charset encoding) {
        return new String(this.message.getBytes(), encoding);
    }

    @Override
    public Buffer toBuffer() {
        return this.message;
    }

    @Override
    public byte[] toBytes() {
        return this.message.getBytes();
    }
}

