/*
 * Decompiled with CFR 0.152.
 */
package ccl.servlet;

import ccl.util.Exitable;
import ccl.util.Init;
import ccl.util.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;

public class DebugServer
implements Exitable,
Runnable {
    public static final int DEFAULT_PORT = 4444;
    private static final String S_INI_FILE_CONTENT = "[Init]\nAuthor=Chr. Clemens Lee\n\n[Help]\nHelpUsage=\nOptions=\n";
    private boolean _bExit = false;
    private Init _init = null;

    public void setExit() {
        this._bExit = true;
    }

    public void initialize(String[] asArg, String sRCSHeader) {
        this._init = new Init(this, asArg, sRCSHeader, S_INI_FILE_CONTENT);
    }

    public void run() {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(4444);
        }
        catch (IOException ioException) {
            Util.printlnErr("Could not listen on port: 4444.");
            System.exit(1);
        }
        Util.println("DebugServer started. Waiting for clients to connect on port 4444 ...\n");
        while (true) {
            Socket clientSocket = null;
            try {
                clientSocket = serverSocket.accept();
            }
            catch (IOException e) {
                Util.printlnErr("Accept failed.");
                System.exit(1);
            }
            Util.println("New connection ...\n");
            try {
                PrintWriter out = new PrintWriter(clientSocket.getOutputStream(), true);
                BufferedReader in = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));
                String inputLine = "";
                String outputLine = "";
                while ((inputLine = in.readLine()) != null) {
                    Util.println(inputLine);
                    out.println(inputLine);
                }
                out.close();
                in.close();
                clientSocket.close();
            }
            catch (IOException ioException) {
                Util.printlnErr(ioException);
            }
            Util.println("\nClient connection closed, waiting for new connection ...\n");
        }
    }

    public static void main(String[] asArg) {
        DebugServer debugServer = new DebugServer();
        debugServer.initialize(asArg, "$Header: /home/clemens/src/java/ccl/src/ccl/servlet/RCS/DebugServer.java,v 1.3 2002/05/20 12:09:12 clemens Exp clemens $");
        if (debugServer._bExit) {
            System.exit(1);
        }
        debugServer.run();
        System.exit(0);
    }
}

