/*
 * Decompiled with CFR 0.152.
 */
package ccl.swing;

import ccl.swing.OKCancelFocusManager;
import ccl.swing.SwingUtil;
import ccl.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JWindow;

public class OKCancelPanel
extends JPanel
implements ActionListener {
    private JButton _btnOK = null;
    private JButton _btnCancel = null;
    private boolean _bOK = false;
    private Window _winParent = null;
    private static final int DEFAULT_GAP = 2;
    private int _defaultGap = 2;
    private FocusManager _fmOriginal = null;
    private FocusManager _fmLast = null;
    private WindowAdapter _pWindowAdapter = null;

    public OKCancelPanel(Window winParent_) {
        this(winParent_, 2);
    }

    public OKCancelPanel(Window winParent_, int gap_) {
        this(winParent_, gap_, false);
    }

    public OKCancelPanel(Window winParent_, boolean bVertical_) {
        this(winParent_, 2, bVertical_);
    }

    public OKCancelPanel(Window winParent_, int gap_, boolean bVertical_) {
        this._winParent = winParent_;
        this._defaultGap = gap_;
        this.setName("OKCancelPanel");
        Color clrBackground = ((Component)this._winParent).getBackground();
        if (this._winParent instanceof JWindow) {
            clrBackground = ((JWindow)this._winParent).getContentPane().getBackground();
        }
        this.setBackground(clrBackground);
        int rows = 0;
        int columns = 2;
        if (bVertical_) {
            rows = 2;
            columns = 0;
        }
        GridLayout pGridLayout = new GridLayout(rows, columns);
        if (bVertical_) {
            pGridLayout.setVgap(this._defaultGap);
        } else {
            pGridLayout.setHgap(this._defaultGap);
        }
        this.setLayout(pGridLayout);
        this._btnOK = new JButton("OK");
        this._btnCancel = new JButton("Cancel");
        this._btnOK.setName("PanelOKButton");
        this._btnCancel.setName("PanelCancelButton");
        SwingUtil.unregisterEnterAction(this._btnCancel);
        this._btnOK.setMnemonic('O');
        this._btnCancel.setMnemonic('C');
        this._btnOK.addActionListener(this);
        this._btnCancel.addActionListener(this);
        this.add(this._btnOK);
        this.add(this._btnCancel);
        JRootPane pRootPane = null;
        if (this._winParent instanceof JDialog) {
            pRootPane = ((JDialog)this._winParent).getRootPane();
        }
        if (this._winParent instanceof JFrame) {
            pRootPane = ((JFrame)this._winParent).getRootPane();
        }
        if (pRootPane != null) {
            pRootPane.setDefaultButton(this._btnOK);
        }
        this._pWindowAdapter = new WindowAdapter(){

            public void windowOpened(WindowEvent pWindowEvent_) {
                Util.debug(this, "windowOpened(..)._winParent: " + OKCancelPanel.this._winParent);
                OKCancelPanel.this._fmOriginal = FocusManager.getCurrentManager();
                OKCancelPanel.this._fmLast = OKCancelPanel.this._fmOriginal;
                FocusManager.setCurrentManager(new OKCancelFocusManager(OKCancelPanel.this._btnOK, OKCancelPanel.this._btnCancel));
            }

            public void windowClosed(WindowEvent pWindowEvent_) {
                FocusManager.setCurrentManager(OKCancelPanel.this._fmOriginal);
                Util.debug(this, "windowClosed(..)._winParent: " + OKCancelPanel.this._winParent);
            }
        };
        this._winParent.addWindowListener(this._pWindowAdapter);
    }

    public WindowAdapter getWindowAdapter() {
        return this._pWindowAdapter;
    }

    public boolean isOK() {
        return this._bOK;
    }

    public void setFalse() {
        this._bOK = false;
    }

    public void switchFocusManager() {
        FocusManager fmTemp = FocusManager.getCurrentManager();
        FocusManager.setCurrentManager(this._fmLast);
        this._fmLast = fmTemp;
    }

    public void continueOperation() {
        this._bOK = false;
        FocusManager.setCurrentManager(new OKCancelFocusManager(this._btnOK, this._btnCancel));
    }

    public void setPreferredButtonSize(Dimension dimButton_) {
        this._btnOK.setPreferredSize(dimButton_);
        this._btnCancel.setPreferredSize(dimButton_);
    }

    public void setMinimumButtonSize(Dimension dimButton_) {
        this._btnOK.setMinimumSize(dimButton_);
        this._btnCancel.setMinimumSize(dimButton_);
    }

    public void setInitialFocusOnOKButton() {
        SwingUtil.setInitialFocus(this._winParent, this._btnOK);
    }

    public JButton getOKButton() {
        return this._btnOK;
    }

    public JButton getCancelButton() {
        return this._btnCancel;
    }

    public void setOKText(String sOKText_) {
        this._btnOK.setText(sOKText_);
        this._btnOK.setMnemonic(sOKText_.charAt(0));
    }

    public void setCancelText(String sCancelText_) {
        this._btnCancel.setText(sCancelText_);
        this._btnCancel.setMnemonic(sCancelText_.charAt(0));
    }

    public void actionPerformed(ActionEvent pActionEvent_) {
        Object oSource = pActionEvent_.getSource();
        if (oSource == this._btnOK) {
            this._bOK = true;
            ((Component)this._winParent).setVisible(false);
        }
        if (oSource == this._btnCancel) {
            this._bOK = false;
            ((Component)this._winParent).setVisible(false);
        }
    }
}

