/*
 * $Header: /home/projects/jaxen/scm/jaxen/src/java/main/org/jaxen/saxpath/helpers/DefaultXPathHandler.java,v 1.6 2005/06/28 13:44:46 elharo Exp $
 * $Revision: 1.6 $
 * $Date: 2005/06/28 13:44:46 $
 *
 * ====================================================================
 *
 * Copyright (C) 2000-2002 bob mcwhirter & James Strachan.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions, and the disclaimer that follows
 *    these conditions in the documentation and/or other materials
 *    provided with the distribution.
 *
 * 3. The name "Jaxen" must not be used to endorse or promote products
 *    derived from this software without prior written permission.  For
 *    written permission, please contact license@jaxen.org.
 *
 * 4. Products derived from this software may not be called "Jaxen", nor
 *    may "Jaxen" appear in their name, without prior written permission
 *    from the Jaxen Project Management (pm@jaxen.org).
 *
 * In addition, we request (but do not require) that you include in the
 * end-user documentation provided with the redistribution and/or in the
 * software itself an acknowledgement equivalent to the following:
 *     "This product includes software developed by the
 *      Jaxen Project <http://www.jaxen.org/>."
 * Alternatively, the acknowledgment may be graphical using the logos
 * available at http://www.jaxen.org/
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE Jaxen AUTHORS OR THE PROJECT
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * ====================================================================
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Jaxen Project and was originally
 * created by bob mcwhirter <bob@werken.com> and
 * James Strachan <jstrachan@apache.org>.  For more information on the
 * Jaxen Project, please see <http://www.jaxen.org/>.
 *
 * $Id: DefaultXPathHandler.java,v 1.6 2005/06/28 13:44:46 elharo Exp $
 */




package org.jaxen.saxpath.helpers;

import org.jaxen.saxpath.SAXPathException;
import org.jaxen.saxpath.XPathHandler;

/**

   Default base class for SAXPath event handlers. 

   This class is available as a convenience base class for SAXPath
   applications: it provides a default do-nothing implementation 
   for all of the callbacks in the core SAXPath handler class, {@link
   org.jaxen.saxpath.XPathHandler}.

   Application writers can extend this class when they need to
   implement only part of the <code>XPathHandler</code>
   interface. Parser writers can instantiate
   this class to provide default handlers when the application has not
   supplied its own. */

public class DefaultXPathHandler implements XPathHandler
{

    public void startXPath() throws SAXPathException
    {
    }

    public void endXPath() throws SAXPathException
    {
    }

    public void startPathExpr() throws SAXPathException
    {
    }

    public void endPathExpr() throws SAXPathException
    {
    }

    public void startAbsoluteLocationPath() throws SAXPathException
    {
    }

    public void endAbsoluteLocationPath() throws SAXPathException
    {
    }

    public void startRelativeLocationPath() throws SAXPathException
    {
    }

    public void endRelativeLocationPath() throws SAXPathException
    {
    }

    public void startNameStep(int axis,
                              String prefix,
                              String localName) throws SAXPathException
    {
    }

    public void endNameStep() throws SAXPathException
    {
    }

    public void startTextNodeStep(int axis) throws SAXPathException
    {
    }
    public void endTextNodeStep() throws SAXPathException
    {
    }

    public void startCommentNodeStep(int axis) throws SAXPathException
    {
    }

    public void endCommentNodeStep() throws SAXPathException
    {
    }

    public void startAllNodeStep(int axis) throws SAXPathException
    {
    }

    public void endAllNodeStep() throws SAXPathException
    {
    }

    public void startProcessingInstructionNodeStep(int axis,
                                                   String name) throws SAXPathException
    {
    }
    public void endProcessingInstructionNodeStep() throws SAXPathException
    {
    }

    public void startPredicate() throws SAXPathException
    {
    }

    public void endPredicate() throws SAXPathException
    {
    }

    public void startFilterExpr() throws SAXPathException
    {
    }

    public void endFilterExpr() throws SAXPathException
    {
    }

    public void startOrExpr() throws SAXPathException
    {
    }

    public void endOrExpr(boolean create) throws SAXPathException
    {
    }

    public void startAndExpr() throws SAXPathException
    {
    }

    public void endAndExpr(boolean create) throws SAXPathException
    {
    }

    public void startEqualityExpr() throws SAXPathException
    {
    }

    public void endEqualityExpr(int operator) throws SAXPathException
    {
    }

    public void startRelationalExpr() throws SAXPathException
    {
    }

    public void endRelationalExpr(int operator) throws SAXPathException
    {
    }

    public void startAdditiveExpr() throws SAXPathException
    {
    }

    public void endAdditiveExpr(int operator) throws SAXPathException
    {
    }

    public void startMultiplicativeExpr() throws SAXPathException
    {
    }

    public void endMultiplicativeExpr(int operator) throws SAXPathException
    {
    }

    public void startUnaryExpr() throws SAXPathException
    {
    }

    public void endUnaryExpr(int operator) throws SAXPathException
    {
    }

    public void startUnionExpr() throws SAXPathException
    {
    }

    public void endUnionExpr(boolean create) throws SAXPathException
    {
    }

    public void number(int number) throws SAXPathException
    {
    }

    public void number(double number) throws SAXPathException
    {
    }

    public void literal(String literal) throws SAXPathException
    {
    }

    public void variableReference(String prefix,
                                  String variableName) throws SAXPathException
    {
    }

    public void startFunction(String prefix,
                              String functionName) throws SAXPathException
    {
    }

    public void endFunction() throws SAXPathException
    {
    }

}
