/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.core;

import java.util.Collection;
import org.jmock.core.Constraint;
import org.jmock.core.VerifyingTestCase;
import org.jmock.core.constraint.And;
import org.jmock.core.constraint.HasProperty;
import org.jmock.core.constraint.HasPropertyWithValue;
import org.jmock.core.constraint.HasToString;
import org.jmock.core.constraint.IsAnything;
import org.jmock.core.constraint.IsArrayContaining;
import org.jmock.core.constraint.IsCloseTo;
import org.jmock.core.constraint.IsCollectionContaining;
import org.jmock.core.constraint.IsCompatibleType;
import org.jmock.core.constraint.IsEqual;
import org.jmock.core.constraint.IsIn;
import org.jmock.core.constraint.IsInstanceOf;
import org.jmock.core.constraint.IsMapContaining;
import org.jmock.core.constraint.IsNot;
import org.jmock.core.constraint.IsNull;
import org.jmock.core.constraint.IsSame;
import org.jmock.core.constraint.Or;
import org.jmock.core.constraint.StringContains;
import org.jmock.core.constraint.StringEndsWith;
import org.jmock.core.constraint.StringStartsWith;
import org.jmock.util.Dummy;

public abstract class MockObjectSupportTestCase
extends VerifyingTestCase {
    public static final Constraint ANYTHING = new IsAnything();
    public static final Constraint NULL = new IsNull();
    public static final Constraint NOT_NULL = new IsNot(NULL);

    public MockObjectSupportTestCase() {
    }

    public MockObjectSupportTestCase(String name) {
        super(name);
    }

    public IsEqual eq(Object operand) {
        return new IsEqual(operand);
    }

    public IsEqual eq(boolean operand) {
        return this.eq(new Boolean(operand));
    }

    public IsEqual eq(byte operand) {
        return this.eq(new Byte(operand));
    }

    public IsEqual eq(short operand) {
        return this.eq(new Short(operand));
    }

    public IsEqual eq(char operand) {
        return this.eq(new Character(operand));
    }

    public IsEqual eq(int operand) {
        return this.eq(new Integer(operand));
    }

    public IsEqual eq(long operand) {
        return this.eq(new Long(operand));
    }

    public IsEqual eq(float operand) {
        return this.eq(new Float(operand));
    }

    public IsEqual eq(double operand) {
        return this.eq(new Double(operand));
    }

    public IsCloseTo eq(double operand, double error) {
        return new IsCloseTo(operand, error);
    }

    public IsSame same(Object operand) {
        return new IsSame(operand);
    }

    public IsInstanceOf isA(Class operandClass) {
        return new IsInstanceOf(operandClass);
    }

    public StringContains stringContains(String substring) {
        return new StringContains(substring);
    }

    public StringContains contains(String substring) {
        return this.stringContains(substring);
    }

    public StringStartsWith startsWith(String substring) {
        return new StringStartsWith(substring);
    }

    public StringEndsWith endsWith(String substring) {
        return new StringEndsWith(substring);
    }

    public IsNot not(Constraint c) {
        return new IsNot(c);
    }

    public And and(Constraint left, Constraint right) {
        return new And(left, right);
    }

    public Or or(Constraint left, Constraint right) {
        return new Or(left, right);
    }

    public Object newDummy(Class dummyType) {
        return Dummy.newDummy(dummyType);
    }

    public Object newDummy(Class dummyType, String name) {
        return Dummy.newDummy(dummyType, name);
    }

    public Object newDummy(final String name) {
        return new Object(){

            public String toString() {
                return name;
            }
        };
    }

    public void assertThat(Object actual, Constraint constraint) {
        if (!constraint.eval(actual)) {
            StringBuffer message = new StringBuffer("\nExpected: ");
            constraint.describeTo(message);
            message.append("\n    got : ").append(actual).append('\n');
            MockObjectSupportTestCase.fail((String)message.toString());
        }
    }

    public void assertThat(boolean actual, Constraint constraint) {
        this.assertThat(new Boolean(actual), constraint);
    }

    public void assertThat(byte actual, Constraint constraint) {
        this.assertThat(new Byte(actual), constraint);
    }

    public void assertThat(short actual, Constraint constraint) {
        this.assertThat(new Short(actual), constraint);
    }

    public void assertThat(char actual, Constraint constraint) {
        this.assertThat(new Character(actual), constraint);
    }

    public void assertThat(int actual, Constraint constraint) {
        this.assertThat(new Integer(actual), constraint);
    }

    public void assertThat(long actual, Constraint constraint) {
        this.assertThat(new Long(actual), constraint);
    }

    public void assertThat(float actual, Constraint constraint) {
        this.assertThat(new Float(actual), constraint);
    }

    public void assertThat(double actual, Constraint constraint) {
        this.assertThat(new Double(actual), constraint);
    }

    public HasPropertyWithValue hasProperty(String propertyName, Constraint expectation) {
        return new HasPropertyWithValue(propertyName, expectation);
    }

    public HasProperty hasProperty(String propertyName) {
        return new HasProperty(propertyName);
    }

    public HasToString toString(Constraint toStringConstraint) {
        return new HasToString(toStringConstraint);
    }

    public IsCompatibleType compatibleType(Class baseType) {
        return new IsCompatibleType(baseType);
    }

    public IsIn isIn(Collection collection) {
        return new IsIn(collection);
    }

    public IsIn isIn(Object[] array) {
        return new IsIn(array);
    }

    public IsCollectionContaining collectionContaining(Constraint elementConstraint) {
        return new IsCollectionContaining(elementConstraint);
    }

    public IsCollectionContaining collectionContaining(Object element) {
        return this.collectionContaining(this.eq(element));
    }

    public IsArrayContaining arrayContaining(Constraint elementConstraint) {
        return new IsArrayContaining(elementConstraint);
    }

    public IsArrayContaining arrayContaining(Object element) {
        return this.arrayContaining(this.eq(element));
    }

    public IsArrayContaining arrayContaining(boolean element) {
        return this.arrayContaining(new Boolean(element));
    }

    public IsArrayContaining arrayContaining(byte element) {
        return this.arrayContaining(new Byte(element));
    }

    public IsArrayContaining arrayContaining(short element) {
        return this.arrayContaining(new Short(element));
    }

    public IsArrayContaining arrayContaining(char element) {
        return this.arrayContaining(new Character(element));
    }

    public IsArrayContaining arrayContaining(int element) {
        return this.arrayContaining(new Integer(element));
    }

    public IsArrayContaining arrayContaining(long element) {
        return this.arrayContaining(new Long(element));
    }

    public IsArrayContaining arrayContaining(float element) {
        return this.arrayContaining(new Float(element));
    }

    public IsArrayContaining arrayContaining(double element) {
        return this.arrayContaining(new Double(element));
    }

    public IsMapContaining mapContaining(Constraint keyConstraint, Constraint valueConstraint) {
        return new IsMapContaining(keyConstraint, valueConstraint);
    }

    public IsMapContaining mapContaining(Object key, Object value) {
        return this.mapContaining(this.eq(key), this.eq(value));
    }

    public IsMapContaining mapWithKey(Object key) {
        return this.mapWithKey(this.eq(key));
    }

    public IsMapContaining mapWithKey(Constraint keyConstraint) {
        return new IsMapContaining(keyConstraint, ANYTHING);
    }

    public IsMapContaining mapWithValue(Object value) {
        return this.mapWithValue(this.eq(value));
    }

    public IsMapContaining mapWithValue(Constraint valueConstraint) {
        return new IsMapContaining(ANYTHING, valueConstraint);
    }
}

