/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.idnumbers;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import net.datafaker.idnumbers.IdNumberGenerator;
import net.datafaker.idnumbers.Utils;
import net.datafaker.providers.base.BaseProviders;
import net.datafaker.providers.base.IdNumber;
import net.datafaker.providers.base.PersonIdNumber;

public class FrenchIdNumber
implements IdNumberGenerator {
    @Override
    public String countryCode() {
        return "FR";
    }

    @Override
    public PersonIdNumber generateValid(BaseProviders faker, IdNumber.IdNumberRequest request) {
        LocalDate birthday = Utils.birthday(faker, request);
        PersonIdNumber.Gender gender = Utils.gender(faker, request);
        String basePart = this.basePart(faker, birthday, gender);
        return new PersonIdNumber(basePart + this.controlKey(basePart), birthday, gender);
    }

    private String basePart(BaseProviders faker, LocalDate birthday, PersonIdNumber.Gender gender) {
        return this.genderNumber(gender) + this.birthDate(birthday) + this.birthLocation(faker) + this.birthNumber(faker);
    }

    private String genderNumber(PersonIdNumber.Gender gender) {
        return PersonIdNumber.Gender.MALE.equals((Object)gender) ? "1" : "2";
    }

    private String birthDate(LocalDate birthday) {
        return birthday.format(DateTimeFormatter.ofPattern("yyMM"));
    }

    private String birthLocation(BaseProviders faker) {
        return faker.regexify("\\d{5}|2[AB]\\d{3}|97[1-6]\\d{2}");
    }

    private String birthNumber(BaseProviders faker) {
        return faker.regexify("\\d{3}");
    }

    String controlKey(String basePart) {
        long basePartLong = Long.parseLong(basePart.replace("2A", "19").replace("2B", "18"));
        long controlKey = 97L - basePartLong % 97L;
        return "%02d".formatted(controlKey);
    }

    @Override
    public String generateInvalid(BaseProviders faker) {
        return this.generateValid(faker).substring(0, 13) + "98";
    }
}

