/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.idnumbers;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import net.datafaker.idnumbers.IdNumberGenerator;
import net.datafaker.idnumbers.Utils;
import net.datafaker.providers.base.BaseProviders;
import net.datafaker.providers.base.IdNumber;
import net.datafaker.providers.base.PersonIdNumber;

public class HungarianIdNumber
implements IdNumberGenerator {
    private static final DateTimeFormatter BIRTHDAY_FORMAT = DateTimeFormatter.ofPattern("yyMMdd");

    @Override
    public String countryCode() {
        return "HU";
    }

    @Override
    public String generateInvalid(BaseProviders faker) {
        String validIdNumber = this.generateValid(faker);
        String basePart = validIdNumber.substring(0, 9);
        int validCheckDigit = Character.getNumericValue(validIdNumber.charAt(9));
        int invalidCheckDigit = (validCheckDigit + 1) % 10;
        return basePart + invalidCheckDigit;
    }

    @Override
    public PersonIdNumber generateValid(BaseProviders faker, IdNumber.IdNumberRequest request) {
        String basePart;
        int checkDigit;
        LocalDate birthday = faker.timeAndDate().birthday();
        PersonIdNumber.Gender gender = Utils.randomGender(faker);
        while ((checkDigit = HungarianIdNumber.getCheckDigit(basePart = this.basePart(faker, birthday, gender))) == 10) {
        }
        String idNumber = basePart + checkDigit;
        return new PersonIdNumber(idNumber, birthday, gender);
    }

    private String basePart(BaseProviders faker, LocalDate birthday, PersonIdNumber.Gender gender) {
        return HungarianIdNumber.firstDigit(birthday.getYear(), gender) + BIRTHDAY_FORMAT.format(birthday) + faker.number().digits(2);
    }

    static int getCheckDigit(String basePart) {
        char[] numbers = basePart.toCharArray();
        int summ = 0;
        for (int i = 0; i < numbers.length; ++i) {
            summ += Character.getNumericValue(numbers[i]) * (i + 1);
        }
        return summ % 11;
    }

    static int firstDigit(int birthYear, PersonIdNumber.Gender gender) {
        return switch (gender) {
            default -> throw new IncompatibleClassChangeError();
            case PersonIdNumber.Gender.MALE -> {
                if (HungarianIdNumber.isInRange(birthYear)) {
                    yield 1;
                }
                yield 3;
            }
            case PersonIdNumber.Gender.FEMALE -> HungarianIdNumber.isInRange(birthYear) ? 2 : 4;
        };
    }

    private static boolean isInRange(int birthYear) {
        return birthYear >= 1900 && birthYear <= 1999;
    }
}

