/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.idnumbers;

import java.util.regex.Pattern;
import net.datafaker.idnumbers.IdNumberGenerator;
import net.datafaker.idnumbers.Utils;
import net.datafaker.providers.base.BaseProviders;
import net.datafaker.providers.base.IdNumber;
import net.datafaker.providers.base.PersonIdNumber;

public class IrishIdNumber
implements IdNumberGenerator {
    private static final Pattern IRISH_PPSN = Pattern.compile("\\d{7}[A-Z]{1,2}$");

    @Override
    public String countryCode() {
        return "IE";
    }

    @Override
    public String generateInvalid(BaseProviders faker) {
        return faker.number().digits(7) + "Z";
    }

    @Override
    public String generateValid(BaseProviders faker) {
        int[] weights = new int[]{8, 7, 6, 5, 4, 3, 2};
        String digitsPpsn = faker.number().digits(7);
        int[] digits = digitsPpsn.chars().map(c -> Character.getNumericValue(c)).toArray();
        String suffix = faker.bool().bool() ? faker.options().option("A", "B", "H", "W") : "";
        int sum = 0;
        for (int i = 0; i < 7; ++i) {
            sum += digits[i] * weights[i];
        }
        if (!suffix.isEmpty()) {
            char extraChar = suffix.charAt(0);
            int extraValue = switch (extraChar) {
                case 'A', 'B', 'H' -> extraChar - 65 + 1;
                case 'W' -> 0;
                default -> throw new IllegalStateException("Unexpected suffix: " + suffix);
            };
            sum += extraValue * 9;
        }
        return digitsPpsn + this.calculateCheckSumCharacter(sum) + suffix;
    }

    boolean validateAndCheckModulo23(String ppsn) {
        if (ppsn == null || !IRISH_PPSN.matcher(ppsn).matches()) {
            return false;
        }
        int sum = 0;
        int[] weights = new int[]{8, 7, 6, 5, 4, 3, 2};
        for (int i = 0; i < 7; ++i) {
            char c = ppsn.charAt(i);
            if (!Character.isDigit(c)) {
                return false;
            }
            sum += Character.getNumericValue(c) * weights[i];
        }
        if (ppsn.length() == 9) {
            int extraValue;
            char extraChar = ppsn.charAt(8);
            switch (extraChar) {
                case 'A': 
                case 'B': 
                case 'H': {
                    int n = extraChar - 65 + 1;
                    break;
                }
                case 'W': {
                    int n = 0;
                    break;
                }
                default: {
                    int n = extraValue = -1;
                }
            }
            if (extraValue == -1) {
                return false;
            }
            sum += extraValue * 9;
        }
        return ppsn.charAt(7) == this.calculateCheckSumCharacter(sum);
    }

    @Override
    public PersonIdNumber generateValid(BaseProviders faker, IdNumber.IdNumberRequest request) {
        return new PersonIdNumber(this.generateValid(faker), Utils.birthday(faker, request), Utils.gender(faker, request));
    }

    private char calculateCheckSumCharacter(int sum) {
        int remainder = sum % 23;
        return remainder == 0 ? (char)'W' : (char)(65 + remainder - 1);
    }
}

