/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.idnumbers;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import net.datafaker.idnumbers.IdNumberGenerator;
import net.datafaker.idnumbers.Utils;
import net.datafaker.providers.base.BaseProviders;
import net.datafaker.providers.base.IdNumber;
import net.datafaker.providers.base.PersonIdNumber;

public class NorwegianIdNumber
implements IdNumberGenerator {
    private static final DateTimeFormatter BIRTHDAY_FORMAT = DateTimeFormatter.ofPattern("ddMMyy");
    private static final int[] CHECKSUM_COEFFICIENTS_K1 = new int[]{3, 7, 6, 1, 8, 9, 4, 5, 2};
    private static final int[] CHECKSUM_COEFFICIENTS_K2 = new int[]{5, 4, 3, 2, 7, 6, 5, 4, 3, 2};

    @Override
    public String countryCode() {
        return "NO";
    }

    @Override
    public PersonIdNumber generateValid(BaseProviders faker, IdNumber.IdNumberRequest request) {
        LocalDate birthday = Utils.birthday(faker, request);
        PersonIdNumber.Gender gender = Utils.gender(faker, request);
        String basePart = this.basePart(faker, birthday, gender);
        String idNumber = "%s%02d".formatted(basePart, this.checksum(basePart));
        return new PersonIdNumber(idNumber, birthday, gender);
    }

    @Override
    public String generateInvalid(BaseProviders faker) {
        String valid = this.generateValid(faker);
        String basePart = valid.substring(0, valid.length() - 2);
        int invalidChecksum = (this.checksum(basePart) + 1) % 100;
        return "%s%02d".formatted(basePart, invalidChecksum);
    }

    String basePart(BaseProviders faker, LocalDate birthday, PersonIdNumber.Gender gender) {
        String birthdayDigits = BIRTHDAY_FORMAT.format(birthday);
        int sequenceNumber = this.generateSequenceNumber(faker, birthday.getYear());
        int genderDigit = this.genderDigit(faker, gender);
        return "%s%02d%s".formatted(birthdayDigits, sequenceNumber, genderDigit);
    }

    private int generateSequenceNumber(BaseProviders faker, int year) {
        if (year >= 1854 && year <= 1899) {
            return faker.random().nextInt(50, 74);
        }
        if (year >= 1940 && year <= 1999) {
            return faker.random().nextInt(90, 99);
        }
        if (year >= 1900 && year <= 1999) {
            return faker.random().nextInt(0, 49);
        }
        if (year >= 2000 && year <= 2039) {
            return faker.random().nextInt(50, 99);
        }
        throw new IllegalArgumentException("Birthday is not in range of supported in Norway");
    }

    private int genderDigit(BaseProviders faker, PersonIdNumber.Gender gender) {
        return switch (gender) {
            default -> throw new IncompatibleClassChangeError();
            case PersonIdNumber.Gender.FEMALE -> faker.options().option((E[])new Integer[]{0, 2, 4, 6, 8});
            case PersonIdNumber.Gender.MALE -> faker.options().option((E[])new Integer[]{1, 3, 5, 7, 9});
        };
    }

    int checksum(String numbers) {
        int k1 = this.modulo11(numbers, CHECKSUM_COEFFICIENTS_K1);
        int k2 = this.modulo11(numbers + k1, CHECKSUM_COEFFICIENTS_K2);
        return k1 * 10 + k2;
    }

    private int modulo11(String numbers, int[] checksumCoefficients) {
        int checkSum = 0;
        for (int i = 0; i < numbers.length(); ++i) {
            int digit = Character.getNumericValue(numbers.charAt(i));
            checkSum += checksumCoefficients[i] * digit;
        }
        return (11 - checkSum % 11) % 10;
    }
}

