/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.providers.base;

import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.Path;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.datafaker.annotations.FakeResolver;
import net.datafaker.providers.base.AbstractProvider;
import net.datafaker.providers.base.BaseProviders;
import net.datafaker.providers.base.ObjectMethods;
import net.datafaker.providers.base.ProviderRegistration;
import net.datafaker.sequence.FakeCollection;
import net.datafaker.sequence.FakeSequence;
import net.datafaker.sequence.FakeStream;
import net.datafaker.service.FakeValuesService;
import net.datafaker.service.FakerContext;
import net.datafaker.service.RandomService;
import net.datafaker.transformations.Schema;

public class BaseFaker
implements BaseProviders {
    private static final Predicate<Class<?>> EVERY_PROVIDER_ALLOWED = t -> true;
    private final FakerContext context;
    private final FakeValuesService fakeValuesService;
    private final Map<Class<?>, AbstractProvider<?>> providersCache = new IdentityHashMap();
    private final Predicate<Class<?>> whiteListPredicate;

    public BaseFaker() {
        this(Locale.ENGLISH);
    }

    public BaseFaker(Locale locale) {
        this(locale, (Random)null);
    }

    public BaseFaker(Random random) {
        this(Locale.ENGLISH, random);
    }

    public BaseFaker(Locale locale, Random random) {
        this(locale, new RandomService(random));
    }

    public BaseFaker(Locale locale, RandomService randomService) {
        this(new FakeValuesService(), new FakerContext(locale, randomService));
    }

    public BaseFaker(FakeValuesService fakeValuesService, FakerContext context) {
        this(fakeValuesService, context, EVERY_PROVIDER_ALLOWED);
    }

    public BaseFaker(FakeValuesService fakeValuesService, FakerContext context, Predicate<Class<?>> whiteListPredicate) {
        this.fakeValuesService = fakeValuesService;
        this.context = context;
        this.whiteListPredicate = whiteListPredicate == null ? EVERY_PROVIDER_ALLOWED : whiteListPredicate;
        fakeValuesService.updateFakeValuesInterfaceMap(context.getLocaleChain());
    }

    @Override
    public FakerContext getContext() {
        return this.context;
    }

    public <T> T doWith(Callable<T> callable, Locale locale) {
        Locale current = this.context.getLocale();
        try {
            T result;
            this.context.setCurrentLocale(locale);
            this.fakeValuesService.updateFakeValuesInterfaceMap(this.context.getLocaleChain());
            T t = result = callable.call();
            return t;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.context.setCurrentLocale(current);
            this.fakeValuesService.updateFakeValuesInterfaceMap(this.context.getLocaleChain());
        }
    }

    public <T> T doWith(Callable<T> callable, long seed) {
        RandomService current = this.context.getRandomService();
        try {
            T result;
            this.context.setRandomService(new RandomService(new Random(seed)));
            T t = result = callable.call();
            return t;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.context.setRandomService(current);
        }
    }

    public <T> T doWith(Callable<T> callable, Locale locale, long seed) {
        Locale currentLocale = this.context.getLocale();
        RandomService currentRandomService = this.context.getRandomService();
        try {
            T result;
            this.context.setRandomService(new RandomService(new Random(seed)));
            this.context.setCurrentLocale(locale);
            T t = result = callable.call();
            return t;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.context.setRandomService(currentRandomService);
            this.context.setCurrentLocale(currentLocale);
        }
    }

    @Override
    public String numerify(String numberString) {
        return this.fakeValuesService.numerify(numberString, this.context);
    }

    @Override
    public String letterify(String letterString) {
        return this.fakeValuesService.letterify(letterString, this.context);
    }

    @Override
    public String letterify(String letterString, boolean isUpper) {
        return this.fakeValuesService.letterify(letterString, this.context, isUpper);
    }

    @Override
    public String bothify(String string) {
        return this.fakeValuesService.bothify(string, this.context);
    }

    @Override
    public String bothify(String string, boolean isUpper) {
        return this.fakeValuesService.bothify(string, this.context, isUpper);
    }

    @Override
    public String regexify(String regex) {
        return this.fakeValuesService.regexify(regex, this.context);
    }

    @Override
    public String examplify(String example) {
        return this.fakeValuesService.examplify(example, this.context);
    }

    @Override
    public String templatify(String string, char char2replace, String ... options) {
        return this.fakeValuesService().templatify(string, char2replace, this.context, options);
    }

    @Override
    public String templatify(String string, Map<Character, String[]> optionsMap) {
        return this.fakeValuesService().templatify(string, optionsMap, this.context);
    }

    @Override
    public String csv(int limit, String ... columnExpressions) {
        return this.fakeValuesService().csv(limit, columnExpressions);
    }

    @Override
    public String csv(String separator, char quote, boolean withHeader, int limit, String ... columnExpressions) {
        return this.fakeValuesService().csv(separator, quote, withHeader, limit, columnExpressions);
    }

    @Override
    public String json(String ... fieldExpressions) {
        return this.fakeValuesService().json(fieldExpressions);
    }

    @Override
    public String jsona(String ... fieldExpressions) {
        return this.fakeValuesService().jsona(fieldExpressions);
    }

    @Override
    public RandomService random() {
        return this.context.getRandomService();
    }

    @Override
    public FakeValuesService fakeValuesService() {
        return this.fakeValuesService;
    }

    @Override
    public void addPath(Locale locale, Path path) {
        this.fakeValuesService().addPath(locale, path);
    }

    @Override
    public void addUrl(Locale locale, URL url) {
        this.fakeValuesService().addUrl(locale, url);
    }

    public static <T> T populate(Class<T> clazz) {
        FakeResolver<T> fakeFactory = FakeResolver.of(clazz);
        return fakeFactory.generate(null);
    }

    public static <T> T populate(Class<T> clazz, Schema<Object, ?> schema) {
        FakeResolver<T> fakeFactory = FakeResolver.of(clazz);
        return fakeFactory.generate(schema);
    }

    @Override
    public <PR extends ProviderRegistration, AP extends AbstractProvider<PR>> AP getProvider(Class<AP> clazz, Function<PR, AP> valueSupplier) {
        return (AP)this.providersCache.computeIfAbsent(clazz, klass -> {
            if (this.whiteListPredicate.test((Class<?>)klass)) {
                return (AbstractProvider)valueSupplier.apply(this.getFaker());
            }
            throw new RuntimeException("Provider '" + klass.getName() + "' is not in white list");
        });
    }

    @Deprecated
    public static <PR extends ProviderRegistration, AP extends AbstractProvider<PR>> AP getProvider(Class<AP> clazz, Function<PR, AP> valueSupplier, PR faker) {
        return faker.getProvider(clazz, valueSupplier);
    }

    public <T> FakeSequence.Builder<T> collection() {
        return new FakeCollection.Builder().faker(this);
    }

    @SafeVarargs
    public final <T> FakeSequence.Builder<T> collection(Supplier<T> ... suppliers) {
        return new FakeCollection.Builder<T>(suppliers).faker(this);
    }

    public final <T> FakeSequence.Builder<T> collection(List<Supplier<T>> suppliers) {
        return new FakeCollection.Builder<T>(suppliers).faker(this);
    }

    public <T> FakeSequence.Builder<T> stream() {
        return new FakeStream.Builder().faker(this);
    }

    @SafeVarargs
    public final <T> FakeSequence.Builder<T> stream(Supplier<T> ... suppliers) {
        return new FakeStream.Builder<T>(suppliers).faker(this);
    }

    public final <T> FakeSequence.Builder<T> stream(List<Supplier<T>> suppliers) {
        return new FakeStream.Builder<T>(suppliers).faker(this);
    }

    @Override
    public String resolve(String key) {
        return this.fakeValuesService.resolve(key, this, this, this.context);
    }

    @Override
    public String resolve(String key, Supplier<String> message) {
        return this.fakeValuesService.resolve(key, this, this, message, this.context);
    }

    @Override
    public String expression(String expression) {
        return this.fakeValuesService.expression(expression, this, this.getContext());
    }

    @Override
    public final <B extends ProviderRegistration> B getFaker() {
        return (B)this;
    }

    public static Method getMethod(AbstractProvider<?> ap, String methodName) {
        return ap == null ? null : ObjectMethods.getMethodByName(ap, methodName);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode());
    }
}

