/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.providers.base;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.datafaker.providers.base.AbstractProvider;
import net.datafaker.providers.base.BaseProviders;
import net.datafaker.providers.base.Name;

public class Credentials
extends AbstractProvider<BaseProviders> {
    public static final int MIN_PASSWORD_LENGTH = 8;
    public static final int MAX_PASSWORD_LENGTH = 16;

    protected Credentials(BaseProviders faker) {
        super(faker);
    }

    public String username() {
        StringBuilder result = new StringBuilder();
        Name name = ((BaseProviders)this.faker).name();
        String firstName = name.firstName().toLowerCase(((BaseProviders)this.faker).getContext().getLocale()) + "." + name.lastName().toLowerCase(((BaseProviders)this.faker).getContext().getLocale());
        for (int i = 0; i < firstName.length(); ++i) {
            char c = firstName.charAt(i);
            if (c == '\'' || Character.isWhitespace(c)) continue;
            result.append(c);
        }
        return result.toString();
    }

    public String password() {
        return this.password(8, 16);
    }

    public String password(boolean includeDigit) {
        return this.password(8, 16, false, false, includeDigit);
    }

    public String password(int minimumLength, int maximumLength) {
        return this.password(minimumLength, maximumLength, false);
    }

    public String password(int minimumLength, int maximumLength, boolean includeUppercase) {
        return this.password(minimumLength, maximumLength, includeUppercase, false);
    }

    public String password(int minimumLength, int maximumLength, boolean includeUppercase, boolean includeSpecial) {
        return this.password(minimumLength, maximumLength, includeUppercase, includeSpecial, true);
    }

    public String password(int minimumLength, int maximumLength, boolean includeUppercase, boolean includeSpecial, boolean includeDigit) {
        return ((BaseProviders)this.faker).text().text(minimumLength, maximumLength, includeUppercase, includeSpecial, includeDigit);
    }

    public String weakPassword() {
        return this.resolve("credentials.weak_password");
    }

    public String userId() {
        return this.userId(this.resolve("credentials.uid_pattern"));
    }

    public String userId(String regex) {
        if (regex == null) {
            return null;
        }
        try {
            Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            return null;
        }
        return ((BaseProviders)this.faker).regexify(regex);
    }
}

