/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.providers.base;

import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonemetadata;
import com.google.i18n.phonenumbers.Phonenumber;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.datafaker.service.FakeValuesService;
import net.datafaker.service.FakerContext;

class PhoneNumberGenerator {
    private static final PhoneNumberUtil libPhoneNumber = PhoneNumberUtil.getInstance();
    private static final Map<CacheKey, String> CACHE = new ConcurrentHashMap<CacheKey, String>();
    private static final int MAX_RETRIES = 100;
    private final FakeValuesService fakeValuesService;
    private final FakerContext context;

    PhoneNumberGenerator(FakeValuesService fakeValuesService, FakerContext context) {
        this.fakeValuesService = fakeValuesService;
        this.context = context;
    }

    String randomPhoneNumber(String countryCodeIso2, PhoneNumberUtil.PhoneNumberType type, PhoneNumberUtil.PhoneNumberFormat format) {
        Phonenumber.PhoneNumber phoneNumber = this.randomPhoneNumber(countryCodeIso2, type);
        return libPhoneNumber.format(phoneNumber, format);
    }

    private Phonenumber.PhoneNumber randomPhoneNumber(String countryCodeIso2, PhoneNumberUtil.PhoneNumberType type) {
        String pattern = CACHE.computeIfAbsent(new CacheKey(countryCodeIso2, type), key -> this.phoneNumberPattern(countryCodeIso2, type));
        Phonenumber.PhoneNumber candidate = this.generatePhoneNumber(countryCodeIso2, pattern);
        for (int i = 0; i < 100 && !libPhoneNumber.isValidNumber(candidate); ++i) {
            candidate = this.generatePhoneNumber(countryCodeIso2, pattern);
        }
        return candidate;
    }

    private Phonenumber.PhoneNumber generatePhoneNumber(String countryCodeIso2, String phoneNumberPattern) {
        String nationalNumber = this.fakeValuesService.regexify(phoneNumberPattern, this.context);
        try {
            return libPhoneNumber.parse((CharSequence)nationalNumber, countryCodeIso2);
        }
        catch (NumberParseException e) {
            throw new RuntimeException("Failed to parse generated phone number %s".formatted(nationalNumber), e);
        }
    }

    private String phoneNumberPattern(String countryCodeIso2, PhoneNumberUtil.PhoneNumberType type) {
        return this.getNumberDescriptionByType(countryCodeIso2, type).getNationalNumberPattern();
    }

    private Phonemetadata.PhoneNumberDesc getNumberDescriptionByType(String countryCodeIso2, PhoneNumberUtil.PhoneNumberType type) {
        Phonemetadata.PhoneMetadata metadata = PhoneNumberGenerator.getPhoneMetadata(countryCodeIso2);
        return switch (type) {
            case PhoneNumberUtil.PhoneNumberType.MOBILE -> metadata.getMobile();
            case PhoneNumberUtil.PhoneNumberType.FIXED_LINE -> metadata.getFixedLine();
            default -> throw new IllegalArgumentException("Unsupported phone number type: " + String.valueOf(type));
        };
    }

    private static Phonemetadata.PhoneMetadata getPhoneMetadata(String countryCodeIso2) {
        try {
            Method method = libPhoneNumber.getClass().getDeclaredMethod("getMetadataForRegion", String.class);
            method.setAccessible(true);
            Phonemetadata.PhoneMetadata metadata = (Phonemetadata.PhoneMetadata)method.invoke((Object)libPhoneNumber, countryCodeIso2);
            return Objects.requireNonNull(metadata, () -> "Unsupported country code: %s".formatted(countryCodeIso2));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to extract phone number metadata for region " + countryCodeIso2, e);
        }
    }

    private record CacheKey(String countryCodeIso2, PhoneNumberUtil.PhoneNumberType phoneNumberType) {
    }
}

