/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.shaded.curiousoddman.rgxgen.visitors;

import java.util.Map;
import java.util.random.RandomGenerator;
import net.datafaker.shaded.curiousoddman.rgxgen.config.RgxGenOption;
import net.datafaker.shaded.curiousoddman.rgxgen.config.RgxGenProperties;
import net.datafaker.shaded.curiousoddman.rgxgen.nodes.Choice;
import net.datafaker.shaded.curiousoddman.rgxgen.nodes.FinalSymbol;
import net.datafaker.shaded.curiousoddman.rgxgen.nodes.Group;
import net.datafaker.shaded.curiousoddman.rgxgen.nodes.GroupRef;
import net.datafaker.shaded.curiousoddman.rgxgen.nodes.Node;
import net.datafaker.shaded.curiousoddman.rgxgen.nodes.NotSymbol;
import net.datafaker.shaded.curiousoddman.rgxgen.nodes.Repeat;
import net.datafaker.shaded.curiousoddman.rgxgen.nodes.Sequence;
import net.datafaker.shaded.curiousoddman.rgxgen.nodes.SymbolSet;
import net.datafaker.shaded.curiousoddman.rgxgen.visitors.GenerationVisitorBuilder;
import net.datafaker.shaded.curiousoddman.rgxgen.visitors.NodeVisitor;
import net.datafaker.shaded.curiousoddman.rgxgen.visitors.NotMatchingGenerationVisitor;
import net.datafaker.shaded.curiousoddman.rgxgen.visitors.helpers.SymbolSetIndexer;

public class GenerationVisitor
implements NodeVisitor {
    protected final StringBuilder aStringBuilder = new StringBuilder();
    protected final Map<Integer, String> aGroupValues;
    protected final RandomGenerator aRandom;
    protected final RgxGenProperties properties;

    protected GenerationVisitor(RandomGenerator random, Map<Integer, String> groupValues, RgxGenProperties properties) {
        this.aRandom = random;
        this.aGroupValues = groupValues;
        this.properties = properties;
    }

    public static GenerationVisitorBuilder builder() {
        return new GenerationVisitorBuilder(true);
    }

    @Override
    public void visit(SymbolSet node) {
        SymbolSetIndexer indexer = node.getSymbolSetIndexer();
        int idx = this.aRandom.nextInt(indexer.size());
        this.aStringBuilder.append(indexer.get(idx));
    }

    @Override
    public void visit(Choice node) {
        Node[] nodes = node.getNodes();
        int idx = this.aRandom.nextInt(nodes.length);
        nodes[idx].visit(this);
    }

    @Override
    public void visit(FinalSymbol node) {
        this.aStringBuilder.append(node.getValue());
    }

    @Override
    public void visit(Repeat node) {
        int max = node.getMax() == -1 ? RgxGenOption.INFINITE_PATTERN_REPETITION.getFromPropertiesOrDefault(this.properties).intValue() : node.getMax();
        int repeat = node.getMin() >= max ? node.getMin() : node.getMin() + this.aRandom.nextInt(max + 1 - node.getMin());
        for (int i = 0; i < repeat; ++i) {
            node.getNode().visit(this);
        }
    }

    @Override
    public void visit(Sequence node) {
        for (Node n : node.getNodes()) {
            n.visit(this);
        }
    }

    @Override
    public void visit(NotSymbol node) {
        NotMatchingGenerationVisitor nmgv = new NotMatchingGenerationVisitor(this.aRandom, this.aGroupValues, this.properties);
        node.getNode().visit(nmgv);
        this.aStringBuilder.append((CharSequence)nmgv.aStringBuilder);
    }

    @Override
    public void visit(GroupRef node) {
        this.aStringBuilder.append(this.aGroupValues.getOrDefault(node.getIndex(), ""));
    }

    @Override
    public void visit(Group node) {
        int start = this.aStringBuilder.length();
        node.getNode().visit(this);
        this.aGroupValues.put(node.getIndex(), this.aStringBuilder.substring(start));
    }

    public String getString() {
        return this.aStringBuilder.toString();
    }
}

