/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.disq;

import net.intelie.disq.Buffer;
import net.intelie.disq.RawQueue;

public class ArrayRawQueue
implements RawQueue {
    private final byte[] memory;
    private final boolean deleteOldestOnOverflow;
    private int begin = 0;
    private int bytes = 0;
    private int count = 0;

    public ArrayRawQueue(int maxSize, boolean deleteOldestOnOverflow) {
        this.memory = new byte[maxSize];
        this.deleteOldestOnOverflow = deleteOldestOnOverflow;
    }

    @Override
    public void reopen() {
    }

    @Override
    public void touch() {
    }

    @Override
    public synchronized long bytes() {
        return this.bytes;
    }

    @Override
    public synchronized long count() {
        return this.count;
    }

    @Override
    public synchronized long remainingBytes() {
        return this.memory.length - this.bytes;
    }

    @Override
    public synchronized long remainingCount() {
        if (this.count() == 0L) {
            return this.memory.length / 4;
        }
        return (long)((double)this.remainingBytes() / ((double)this.bytes() / (double)this.count()));
    }

    @Override
    public synchronized void clear() {
        this.bytes = 0;
        this.count = 0;
        this.begin = 0;
    }

    @Override
    public void notifyFailedRead() {
    }

    @Override
    public synchronized boolean pop(Buffer buffer) {
        if (!this.peek(buffer)) {
            return false;
        }
        int read = 4 + buffer.count();
        this.begin = (this.begin + read) % this.memory.length;
        this.bytes -= read;
        --this.count;
        return true;
    }

    @Override
    public synchronized boolean peek(Buffer buffer) {
        if (this.bytes == 0) {
            return false;
        }
        int size = this.readInt();
        buffer.setCount(size, false);
        int myBegin = (this.begin + 4) % this.memory.length;
        int firstSize = Math.min(this.memory.length - myBegin, size);
        System.arraycopy(this.memory, myBegin, buffer.buf(), 0, firstSize);
        if (firstSize < size) {
            System.arraycopy(this.memory, 0, buffer.buf(), firstSize, size - firstSize);
        }
        return true;
    }

    @Override
    public synchronized boolean push(Buffer buffer) {
        int size = buffer.count();
        if (size + 4 > this.memory.length) {
            return false;
        }
        while (this.deleteOldestOnOverflow && this.bytes + size + 4 > this.memory.length) {
            int oldSize = this.readInt();
            this.begin = (this.begin + 4 + oldSize) % this.memory.length;
            this.bytes -= 4 + oldSize;
            --this.count;
        }
        if (this.bytes + size + 4 > this.memory.length) {
            return false;
        }
        this.writeInt(size);
        int myBegin = (this.begin + this.bytes + 4) % this.memory.length;
        int firstSize = Math.min(this.memory.length - myBegin, size);
        System.arraycopy(buffer.buf(), 0, this.memory, myBegin, firstSize);
        if (firstSize < size) {
            System.arraycopy(buffer.buf(), firstSize, this.memory, 0, size - firstSize);
        }
        this.bytes += 4 + buffer.count();
        ++this.count;
        return true;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    private int readInt() {
        int ret = 0;
        for (int i = 0; i < 4; ++i) {
            ret <<= 8;
            ret |= this.memory[(this.begin + i) % this.memory.length] & 0xFF;
        }
        return ret;
    }

    private void writeInt(int value) {
        for (int i = 0; i < 4; ++i) {
            this.memory[(this.begin + this.bytes + 3 - i) % this.memory.length] = (byte)(value & 0xFF);
            value >>= 8;
        }
    }
}

