/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.disq;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Buffer {
    private static final Logger LOGGER = LoggerFactory.getLogger(Buffer.class);
    private final int maxCapacity;
    private byte[] buf;
    private int count;

    public Buffer() {
        this(-1);
    }

    public Buffer(int maxCapacity) {
        this(32, maxCapacity);
    }

    public Buffer(int initialCapacity, int maxCapacity) {
        this(new byte[initialCapacity], 0, maxCapacity);
    }

    public Buffer(byte[] buf) {
        this(buf, buf.length, buf.length);
    }

    private Buffer(byte[] buf, int count, int maxCapacity) {
        this.buf = buf;
        this.count = count;
        this.maxCapacity = maxCapacity;
    }

    public int currentCapacity() {
        return this.buf.length;
    }

    public int count() {
        return this.count;
    }

    public void clear() {
        this.count = 0;
    }

    public byte[] buf() {
        return this.buf;
    }

    public byte[] toArray() {
        return Arrays.copyOf(this.buf, this.count);
    }

    public void setCountAtLeast(int newCount, boolean preserve) {
        if (newCount > this.count) {
            this.setCount(newCount, preserve);
        }
    }

    public void setCount(int newCount, boolean preserve) {
        this.ensureCapacity(newCount, preserve);
        this.count = newCount;
    }

    public void ensureCapacity(int capacity) {
        this.ensureCapacity(capacity, false);
    }

    public void ensureCapacity(int capacity, boolean preserve) {
        if (capacity <= this.buf.length) {
            return;
        }
        int newCapacity = this.findBestNewCapacity(capacity);
        if (capacity > newCapacity) {
            LOGGER.info("Buffer overflowed. Len={}, Max={}", (Object)capacity, (Object)this.maxCapacity);
            throw new IllegalStateException("Buffer overflowed: " + capacity + "/" + this.maxCapacity + " bytes");
        }
        this.buf = preserve ? Arrays.copyOf(this.buf, newCapacity) : new byte[newCapacity];
    }

    private int findBestNewCapacity(int capacity) {
        int newCapacity = 1 << 32 - Integer.numberOfLeadingZeros(capacity) - 1;
        if (newCapacity < capacity) {
            newCapacity <<= 1;
        }
        if (this.maxCapacity >= 0) {
            newCapacity = Math.min(newCapacity, this.maxCapacity);
        }
        return newCapacity;
    }

    public OutStream write() {
        return this.write(0);
    }

    public OutStream write(int start) {
        return new OutStream(start);
    }

    public InStream read() {
        return this.read(0);
    }

    public InStream read(int start) {
        return new InStream(start);
    }

    public class InStream
    extends InputStream {
        private int marked = 0;
        private int position = 0;

        public InStream(int start) {
            this.position = this.marked = start;
        }

        @Override
        public int read() throws IOException {
            if (this.position + 1 > Buffer.this.count) {
                return -1;
            }
            return Buffer.this.buf[this.position++] & 0xFF;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.position >= Buffer.this.count) {
                return -1;
            }
            int toRead = Math.min(Buffer.this.count - this.position, len);
            System.arraycopy(Buffer.this.buf, this.position, b, off, toRead);
            this.position += toRead;
            return toRead;
        }

        @Override
        public long skip(long n) throws IOException {
            long toSkip = Math.min((long)(Buffer.this.count - this.position), n);
            this.position = (int)((long)this.position + toSkip);
            return toSkip;
        }

        @Override
        public int available() throws IOException {
            return Buffer.this.count - this.position;
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.marked = this.position;
        }

        @Override
        public synchronized void reset() throws IOException {
            this.position = this.marked;
        }
    }

    public class OutStream
    extends OutputStream {
        private int position;

        public OutStream(int start) {
            this.position = start;
        }

        @Override
        public void write(int b) throws IOException {
            Buffer.this.setCountAtLeast(this.position + 1, true);
            ((Buffer)Buffer.this).buf[this.position++] = (byte)b;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            Buffer.this.setCountAtLeast(this.position + len, true);
            System.arraycopy(b, off, Buffer.this.buf, this.position, len);
            this.position += len;
        }
    }
}

