/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.disq;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import net.intelie.disq.Buffer;

public class DataFileReader
implements Closeable {
    private final DataInputStream stream;
    private final FileInputStream fis;

    public DataFileReader(Path file, long position) throws IOException {
        this.fis = new FileInputStream(file.toFile());
        this.skipToPosition(position);
        this.stream = new DataInputStream(new BufferedInputStream(this.fis, 0x100000));
    }

    private void skipToPosition(long position) throws IOException {
        while (position > 0L) {
            position -= this.fis.skip(position);
        }
    }

    public long size() throws IOException {
        return this.fis.getChannel().size();
    }

    public int read(Buffer buffer) throws IOException {
        return this.internalRead(buffer, false);
    }

    private int internalRead(Buffer buffer, boolean peek) throws IOException {
        if (peek) {
            this.stream.mark(4);
        }
        int size = this.stream.readInt();
        if (peek) {
            this.stream.reset();
        }
        this.stream.mark(4 + size);
        int total = 4;
        buffer.setCount(size, false);
        int offset = 0;
        if (peek) {
            this.stream.readInt();
        }
        while (size > 0) {
            int read = this.stream.read(buffer.buf(), offset, size);
            size -= read;
            offset += read;
            total += read;
        }
        if (peek) {
            this.stream.reset();
        }
        return total;
    }

    public int peek(Buffer buffer) throws IOException {
        return this.internalRead(buffer, true);
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }
}

