/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.disq;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Path;
import net.intelie.disq.Buffer;

public class DataFileWriter
implements Closeable {
    public static final int OVERHEAD = 4;
    private final DataOutputStream stream;
    private final FileOutputStream fos;
    private final File file;

    public DataFileWriter(Path file, long position) throws IOException {
        this.file = file.toFile();
        this.setLength(this.file, position);
        this.fos = new FileOutputStream(this.file, true);
        this.stream = new DataOutputStream(new BufferedOutputStream(this.fos, 0x100000));
    }

    private void setLength(File file, long size) throws IOException {
        RandomAccessFile rand = new RandomAccessFile(file, "rws");
        rand.setLength(size);
        rand.close();
    }

    public int write(Buffer buffer) throws IOException {
        this.stream.writeInt(buffer.count());
        this.stream.write(buffer.buf(), 0, buffer.count());
        return buffer.count() + 4;
    }

    public void flush() throws IOException {
        this.stream.flush();
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }
}

