/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.disq;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import net.intelie.disq.DeleteFileVisitor;
import net.intelie.disq.DiskRawQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Lenient {
    private static final Logger LOGGER = LoggerFactory.getLogger(Lenient.class);
    private final DiskRawQueue queue;

    public Lenient(DiskRawQueue queue) {
        this.queue = queue;
    }

    public long perform(Op supplier) throws IOException {
        try {
            this.queue.touch();
            return supplier.call();
        }
        catch (Throwable e) {
            LOGGER.info("First try queue operation error", e);
            this.queue.reopen();
            try {
                this.queue.touch();
                return supplier.call();
            }
            catch (Throwable e2) {
                LOGGER.info("Second try queue operation error", e2);
                this.queue.reopen();
                throw e2;
            }
        }
    }

    public long performSafe(Op supplier, long defaultValue) {
        try {
            return this.perform(supplier);
        }
        catch (Throwable e) {
            return defaultValue;
        }
    }

    public void safeClose(AutoCloseable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Throwable e) {
            LOGGER.info("Error closing closeable", e);
        }
    }

    public void safeDelete(Path directory) {
        try {
            Files.walkFileTree(directory, new DeleteFileVisitor());
        }
        catch (Throwable e) {
            LOGGER.info("Error deleting directory", e);
        }
    }

    public static interface Op {
        public long call() throws IOException;
    }
}

