/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.g2d.UGraphicG2d;

public class EmptyImageBuilder {
    private final BufferedImage im;
    private final Graphics2D g2d;

    public EmptyImageBuilder(double d, double d2, Color color) {
        this((int)d, (int)d2, color);
    }

    public EmptyImageBuilder(int n, int n2, Color color) {
        Log.info("Creating image " + n + "x" + n2);
        this.im = new BufferedImage(n, n2, color == null ? 2 : 1);
        this.g2d = this.im.createGraphics();
        this.g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (color != null) {
            this.g2d.setColor(color);
            this.g2d.fillRect(0, 0, n, n2);
        }
    }

    public EmptyImageBuilder(int n, int n2, Color color, double d) {
        this((double)n * d, (double)n2 * d, color);
        if (d != 1.0) {
            this.g2d.setTransform(AffineTransform.getScaleInstance(d, d));
        }
    }

    public BufferedImage getBufferedImage() {
        return this.im;
    }

    public Graphics2D getGraphics2D() {
        return this.g2d;
    }

    public UGraphicG2d getUGraphicG2d() {
        UGraphicG2d uGraphicG2d = new UGraphicG2d(new ColorMapperIdentity(), this.g2d, 1.0);
        uGraphicG2d.setBufferedImage(this.im);
        return uGraphicG2d;
    }
}

