/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.OptionPrint;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.preproc.Defines;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Option {
    private final List<String> excludes = new ArrayList<String>();
    private final List<String> config = new ArrayList<String>();
    private final Map<String, String> defines = new LinkedHashMap<String, String>();
    private String charset;
    private boolean computeurl = false;
    private boolean decodeurl = false;
    private boolean pipe = false;
    private boolean syntax = false;
    private boolean checkOnly = false;
    private boolean pattern = false;
    private boolean duration = false;
    private int nbThreads = 0;
    private int ftpPort = -1;
    private File outputDir = null;
    private File outputFile = null;
    private final List<String> result = new ArrayList<String>();
    private FileFormat fileFormat = FileFormat.PNG;

    public Option() {
    }

    public FileFormat getFileFormat() {
        return this.fileFormat;
    }

    public void setFileFormat(FileFormat fileFormat) {
        this.fileFormat = fileFormat;
    }

    public Option(String ... stringArray) throws InterruptedException, IOException {
        if (stringArray.length == 0) {
            OptionFlags.getInstance().setGui(true);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.equalsIgnoreCase("-tsvg") || string.equalsIgnoreCase("-svg")) {
                this.setFileFormat(FileFormat.SVG);
                continue;
            }
            if (string.equalsIgnoreCase("-thtml") || string.equalsIgnoreCase("-html")) {
                this.setFileFormat(FileFormat.HTML);
                continue;
            }
            if (string.equalsIgnoreCase("-txmi") || string.equalsIgnoreCase("-xmi")) {
                this.setFileFormat(FileFormat.XMI_STANDARD);
                continue;
            }
            if (string.equalsIgnoreCase("-txmi:argo") || string.equalsIgnoreCase("-xmi:argo")) {
                this.setFileFormat(FileFormat.XMI_ARGO);
                continue;
            }
            if (string.equalsIgnoreCase("-txmi:star") || string.equalsIgnoreCase("-xmi:star")) {
                this.setFileFormat(FileFormat.XMI_STAR);
                continue;
            }
            if (string.equalsIgnoreCase("-teps") || string.equalsIgnoreCase("-eps")) {
                this.setFileFormat(FileFormat.EPS);
                continue;
            }
            if (string.equalsIgnoreCase("-teps:text") || string.equalsIgnoreCase("-eps:text")) {
                this.setFileFormat(FileFormat.EPS_TEXT);
                continue;
            }
            if (string.equalsIgnoreCase("-ttxt") || string.equalsIgnoreCase("-txt")) {
                this.setFileFormat(FileFormat.ATXT);
                continue;
            }
            if (string.equalsIgnoreCase("-tutxt") || string.equalsIgnoreCase("-utxt")) {
                this.setFileFormat(FileFormat.UTXT);
                continue;
            }
            if (string.equalsIgnoreCase("-png") || string.equalsIgnoreCase("-tpng")) {
                this.setFileFormat(FileFormat.PNG);
                continue;
            }
            if (string.equalsIgnoreCase("-pdf") || string.equalsIgnoreCase("-tpdf")) {
                this.setFileFormat(FileFormat.PDF);
                continue;
            }
            if (string.equalsIgnoreCase("-output") || string.equalsIgnoreCase("-o")) {
                if (++i == stringArray.length) continue;
                this.outputDir = new File(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(stringArray[i]));
                continue;
            }
            if (string.equalsIgnoreCase("-ofile")) {
                if (++i == stringArray.length) continue;
                this.outputFile = new File(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(stringArray[i]));
                continue;
            }
            if (string.equalsIgnoreCase("-graphvizdot") || string.equalsIgnoreCase("-graphviz_dot")) {
                if (++i == stringArray.length) continue;
                OptionFlags.getInstance().setDotExecutable(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(stringArray[i]));
                continue;
            }
            if (string.equalsIgnoreCase("-charset")) {
                if (++i == stringArray.length) continue;
                this.charset = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(stringArray[i]);
                continue;
            }
            if (string.startsWith("-o") && string.length() > 3) {
                string = string.substring(2);
                this.outputDir = new File(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string));
                continue;
            }
            if (string.equalsIgnoreCase("-recurse") || string.equalsIgnoreCase("-r")) continue;
            if (string.equalsIgnoreCase("-exclude") || string.equalsIgnoreCase("-x")) {
                if (++i == stringArray.length) continue;
                this.excludes.add(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(stringArray[i]));
                continue;
            }
            if (string.equalsIgnoreCase("-nbthread") || string.equalsIgnoreCase("-nbthreads")) {
                if (++i == stringArray.length) continue;
                String string2 = stringArray[i];
                if ("auto".equalsIgnoreCase(string2)) {
                    this.nbThreads = Option.defaultNbThreads();
                    continue;
                }
                if (!string2.matches("\\d+")) continue;
                this.nbThreads = Integer.parseInt(string2);
                continue;
            }
            if (string.equalsIgnoreCase("-checkonly")) {
                this.checkOnly = true;
                OptionFlags.getInstance().setFailOnError(true);
                continue;
            }
            if (string.equalsIgnoreCase("-config")) {
                if (++i == stringArray.length) continue;
                this.initConfig(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(stringArray[i]));
                continue;
            }
            if (string.equalsIgnoreCase("-computeurl") || string.equalsIgnoreCase("-encodeurl")) {
                this.computeurl = true;
                continue;
            }
            if (string.startsWith("-x")) {
                string = string.substring(2);
                this.excludes.add(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string));
                continue;
            }
            if (string.equalsIgnoreCase("-verbose") || string.equalsIgnoreCase("-v")) {
                OptionFlags.getInstance().setVerbose(true);
                continue;
            }
            if (string.equalsIgnoreCase("-pipe") || string.equalsIgnoreCase("-p")) {
                this.pipe = true;
                continue;
            }
            if (string.equalsIgnoreCase("-pattern")) {
                this.pattern = true;
                continue;
            }
            if (string.equalsIgnoreCase("-syntax")) {
                this.syntax = true;
                OptionFlags.getInstance().setQuiet(true);
                continue;
            }
            if (string.equalsIgnoreCase("-duration")) {
                this.duration = true;
                continue;
            }
            if (string.equalsIgnoreCase("-keepfiles") || string.equalsIgnoreCase("-keepfile")) {
                OptionFlags.getInstance().setKeepTmpFiles(true);
                continue;
            }
            if (string.equalsIgnoreCase("-metadata")) {
                OptionFlags.getInstance().setMetadata(true);
                continue;
            }
            if (string.equalsIgnoreCase("-logdata")) {
                if (++i == stringArray.length) continue;
                OptionFlags.getInstance().setLogData(new File(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(stringArray[i])));
                continue;
            }
            if (string.equalsIgnoreCase("-word")) {
                OptionFlags.getInstance().setWord(true);
                OptionFlags.getInstance().setQuiet(true);
                continue;
            }
            if (string.equalsIgnoreCase("-quiet")) {
                OptionFlags.getInstance().setQuiet(true);
                continue;
            }
            if (string.equalsIgnoreCase("-decodeurl")) {
                this.decodeurl = true;
                continue;
            }
            if (string.equalsIgnoreCase("-version")) {
                OptionPrint.printVersion();
                continue;
            }
            if (string.matches("(?i)^-li[sc][ea]n[sc]e\\s*$")) {
                OptionPrint.printLicense();
                continue;
            }
            if (string.equalsIgnoreCase("-checkversion")) {
                OptionPrint.checkVersion();
                continue;
            }
            if (string.startsWith("-D")) {
                this.manageDefine(string.substring(2));
                continue;
            }
            if (string.startsWith("-S")) {
                this.manageSkinParam(string.substring(2));
                continue;
            }
            if (string.equalsIgnoreCase("-testdot")) {
                OptionPrint.printTestDot();
                continue;
            }
            if (string.equalsIgnoreCase("-about") || string.equalsIgnoreCase("-author") || string.equalsIgnoreCase("-authors")) {
                OptionPrint.printAbout();
                continue;
            }
            if (string.equalsIgnoreCase("-help") || string.equalsIgnoreCase("-h") || string.equalsIgnoreCase("-?")) {
                OptionPrint.printHelp();
                continue;
            }
            if (string.equalsIgnoreCase("-language")) {
                OptionPrint.printLanguage();
                continue;
            }
            if (string.equalsIgnoreCase("-gui")) {
                OptionFlags.getInstance().setGui(true);
                continue;
            }
            if (string.equalsIgnoreCase("-encodesprite")) {
                OptionFlags.getInstance().setEncodesprite(true);
                continue;
            }
            if (string.equalsIgnoreCase("-nosuggestengine")) {
                OptionFlags.getInstance().setUseSuggestEngine(false);
                continue;
            }
            if (string.equalsIgnoreCase("-failonerror")) {
                OptionFlags.getInstance().setFailOnError(true);
                continue;
            }
            if (string.equalsIgnoreCase("-printfonts")) {
                OptionFlags.getInstance().setPrintFonts(true);
                continue;
            }
            if (string.toLowerCase().startsWith("-ftp")) {
                int n = string.indexOf(58);
                if (n == -1) {
                    this.ftpPort = 4242;
                    continue;
                }
                this.ftpPort = Integer.parseInt(string.substring(n + 1));
                continue;
            }
            if (string.startsWith("-c")) {
                string = string.substring(2);
                this.config.add(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string));
                continue;
            }
            this.result.add(string);
        }
    }

    public int getFtpPort() {
        return this.ftpPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initConfig(String string) throws IOException {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                this.config.add(string2);
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
    }

    private void manageDefine(String string) {
        Pattern pattern = Pattern.compile("^(\\w+)(?:=(.*))?$");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            this.define(matcher.group(1), matcher.group(2));
        }
    }

    private void manageSkinParam(String string) {
        Pattern pattern = Pattern.compile("^(\\w+)(?:=(.*))?$");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            this.skinParam(matcher.group(1), matcher.group(2));
        }
    }

    private void skinParam(String string, String string2) {
        if (string != null && string2 != null) {
            this.config.add("skinparamlocked " + string + " " + string2);
        }
    }

    public final File getOutputDir() {
        return this.outputDir;
    }

    public static final String getPattern() {
        return "(?i)^.*\\.(txt|tex|java|htm|html|c|h|cpp|apt)$";
    }

    public void setOutputDir(File file) {
        this.outputDir = file;
    }

    public final List<String> getExcludes() {
        return Collections.unmodifiableList(this.excludes);
    }

    public Defines getDefaultDefines() {
        Defines defines = new Defines();
        for (Map.Entry<String, String> entry : this.defines.entrySet()) {
            defines.define(entry.getKey(), entry.getValue());
        }
        return defines;
    }

    public void define(String string, String string2) {
        this.defines.put(string, string2);
    }

    public List<String> getConfig() {
        return Collections.unmodifiableList(this.config);
    }

    public final List<String> getResult() {
        return Collections.unmodifiableList(this.result);
    }

    public final String getCharset() {
        return this.charset;
    }

    public void setCharset(String string) {
        this.charset = string;
    }

    public final boolean isComputeurl() {
        return this.computeurl;
    }

    public final boolean isDecodeurl() {
        return this.decodeurl;
    }

    public final boolean isPipe() {
        return this.pipe;
    }

    public final boolean isSyntax() {
        return this.syntax;
    }

    public final boolean isPattern() {
        return this.pattern;
    }

    public FileFormatOption getFileFormatOption() {
        return new FileFormatOption(this.getFileFormat());
    }

    public final boolean isDuration() {
        return this.duration;
    }

    public final int getNbThreads() {
        return this.nbThreads;
    }

    public final void setNbThreads(int n) {
        this.nbThreads = n;
    }

    public static int defaultNbThreads() {
        return Runtime.getRuntime().availableProcessors();
    }

    public final boolean isCheckOnly() {
        return this.checkOnly;
    }

    public final void setCheckOnly(boolean bl) {
        this.checkOnly = bl;
    }

    public final File getOutputFile() {
        return this.outputFile;
    }
}

