/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sourceforge.plantuml.DiagramType;
import net.sourceforge.plantuml.ErrorUml;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.PSystem;
import net.sourceforge.plantuml.PSystemError;
import net.sourceforge.plantuml.PSystemFactory;
import net.sourceforge.plantuml.PSystemSingleBuilder;
import net.sourceforge.plantuml.UmlSource;
import net.sourceforge.plantuml.acearth.PSystemXearthFactory;
import net.sourceforge.plantuml.activitydiagram.ActivityDiagramFactory;
import net.sourceforge.plantuml.activitydiagram2.ActivityDiagramFactory2;
import net.sourceforge.plantuml.classdiagram.ClassDiagramFactory;
import net.sourceforge.plantuml.compositediagram.CompositeDiagramFactory;
import net.sourceforge.plantuml.descdiagram.DescriptionDiagramFactory;
import net.sourceforge.plantuml.directdot.PSystemDotFactory;
import net.sourceforge.plantuml.ditaa.PSystemDitaaFactory;
import net.sourceforge.plantuml.donors.PSystemDonorsFactory;
import net.sourceforge.plantuml.eggs.PSystemAppleTwoFactory;
import net.sourceforge.plantuml.eggs.PSystemEggFactory;
import net.sourceforge.plantuml.eggs.PSystemLostFactory;
import net.sourceforge.plantuml.eggs.PSystemPathFactory;
import net.sourceforge.plantuml.eggs.PSystemRIPFactory;
import net.sourceforge.plantuml.flowdiagram.FlowDiagramFactory;
import net.sourceforge.plantuml.font.PSystemListFontsFactory;
import net.sourceforge.plantuml.jcckit.PSystemJcckitFactory;
import net.sourceforge.plantuml.logo.PSystemLogoFactory;
import net.sourceforge.plantuml.objectdiagram.ObjectDiagramFactory;
import net.sourceforge.plantuml.oregon.PSystemOregonFactory;
import net.sourceforge.plantuml.postit.PostIdDiagramFactory;
import net.sourceforge.plantuml.printskin.PrintSkinFactory;
import net.sourceforge.plantuml.project2.PSystemProjectFactory2;
import net.sourceforge.plantuml.salt.PSystemSaltFactory;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagramFactory;
import net.sourceforge.plantuml.statediagram.StateDiagramFactory;
import net.sourceforge.plantuml.sudoku.PSystemSudokuFactory;
import net.sourceforge.plantuml.turing.PSystemTuringFactory;
import net.sourceforge.plantuml.version.License;
import net.sourceforge.plantuml.version.PSystemLicenseFactory;
import net.sourceforge.plantuml.version.PSystemVersionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSystemBuilder {
    public final PSystem createPSystem(List<? extends CharSequence> list) {
        List<PSystemFactory> list2 = this.getAllFactories();
        UmlSource umlSource = new UmlSource(list);
        DiagramType diagramType = umlSource.getDiagramType();
        ArrayList<PSystemError> arrayList = new ArrayList<PSystemError>();
        for (PSystemFactory pSystemFactory : list2) {
            if (diagramType != pSystemFactory.getDiagramType()) continue;
            PSystem pSystem = new PSystemSingleBuilder(umlSource, pSystemFactory).getPSystem();
            if (this.isOk(pSystem)) {
                return pSystem;
            }
            arrayList.add((PSystemError)pSystem);
        }
        PSystemError pSystemError = this.merge(arrayList);
        if (!OptionFlags.getInstance().isQuiet()) {
            pSystemError.print(System.err);
        }
        return pSystemError;
    }

    private List<PSystemFactory> getAllFactories() {
        ArrayList<PSystemFactory> arrayList = new ArrayList<PSystemFactory>();
        arrayList.add(new SequenceDiagramFactory());
        arrayList.add(new ClassDiagramFactory());
        arrayList.add(new ActivityDiagramFactory());
        arrayList.add(new ActivityDiagramFactory2());
        arrayList.add(new DescriptionDiagramFactory());
        arrayList.add(new StateDiagramFactory());
        arrayList.add(new ActivityDiagramFactory2());
        arrayList.add(new CompositeDiagramFactory());
        arrayList.add(new ObjectDiagramFactory());
        arrayList.add(new PostIdDiagramFactory());
        arrayList.add(new PrintSkinFactory());
        arrayList.add(new PSystemLicenseFactory());
        arrayList.add(new PSystemVersionFactory());
        arrayList.add(new PSystemDonorsFactory());
        arrayList.add(new PSystemListFontsFactory());
        arrayList.add(new PSystemSaltFactory(DiagramType.SALT));
        arrayList.add(new PSystemSaltFactory(DiagramType.UML));
        arrayList.add(new PSystemDotFactory(DiagramType.DOT));
        arrayList.add(new PSystemDotFactory(DiagramType.UML));
        if (!License.isCloseSource()) {
            arrayList.add(new PSystemDitaaFactory(DiagramType.DITAA));
            arrayList.add(new PSystemDitaaFactory(DiagramType.UML));
            arrayList.add(new PSystemJcckitFactory(DiagramType.JCCKIT));
            arrayList.add(new PSystemJcckitFactory(DiagramType.UML));
            arrayList.add(new PSystemLogoFactory());
            arrayList.add(new PSystemSudokuFactory());
            arrayList.add(new PSystemTuringFactory());
        }
        arrayList.add(new PSystemEggFactory());
        arrayList.add(new PSystemAppleTwoFactory());
        arrayList.add(new PSystemRIPFactory());
        arrayList.add(new PSystemLostFactory());
        arrayList.add(new PSystemPathFactory());
        arrayList.add(new PSystemOregonFactory());
        if (!License.isCloseSource()) {
            arrayList.add(new PSystemXearthFactory());
        }
        arrayList.add(new PSystemProjectFactory2());
        arrayList.add(new FlowDiagramFactory());
        return arrayList;
    }

    private PSystemError merge(Collection<PSystemError> collection) {
        UmlSource umlSource = null;
        ArrayList<ErrorUml> arrayList = new ArrayList<ErrorUml>();
        for (PSystemError pSystemError : collection) {
            if (pSystemError.getSource() != null && umlSource == null) {
                umlSource = pSystemError.getSource();
            }
            arrayList.addAll(pSystemError.getErrorsUml());
        }
        if (umlSource == null) {
            throw new IllegalStateException();
        }
        return new PSystemError(umlSource, arrayList);
    }

    private boolean isOk(PSystem pSystem) {
        return pSystem != null && !(pSystem instanceof PSystemError);
    }
}

