/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;

public class UrlBuilder {
    private static final String URL_PATTERN = "\\[\\[(\"[^\"]+\"|[^{} \\]\\[]*)(?: *\\{([^{}]+)\\})?(?: *([^\\]\\[]+))?\\]\\]";
    private final String topurl;
    private boolean strict;

    public UrlBuilder(String string, boolean bl) {
        this.topurl = string;
        this.strict = bl;
    }

    public Url getUrl(String string) {
        Pattern pattern = this.strict ? Pattern.compile("(?i)^\\[\\[(\"[^\"]+\"|[^{} \\]\\[]*)(?: *\\{([^{}]+)\\})?(?: *([^\\]\\[]+))?\\]\\]$") : Pattern.compile(".*\\[\\[(\"[^\"]+\"|[^{} \\]\\[]*)(?: *\\{([^{}]+)\\})?(?: *([^\\]\\[]+))?\\]\\].*");
        Matcher matcher = pattern.matcher(string.trim());
        if (!matcher.matches()) {
            return null;
        }
        String string2 = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(matcher.group(1));
        if (!string2.startsWith("http:") && !string2.startsWith("https:") && this.topurl != null) {
            string2 = this.topurl + string2;
        }
        return new Url(string2, matcher.group(2), matcher.group(3));
    }

    public static String getRegexp() {
        return URL_PATTERN;
    }

    public static String purgeUrl(String string) {
        Pattern pattern = Pattern.compile("(?: )*\\[\\[(\"[^\"]+\"|[^{} \\]\\[]*)(?: *\\{([^{}]+)\\})?(?: *([^\\]\\[]+))?\\]\\](?: )*");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.find()) {
            throw new IllegalStateException();
        }
        String string2 = matcher.group(0);
        int n = string.indexOf(string2);
        return string.substring(0, n) + string.substring(n + string2.length());
    }
}

