/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.acearth;

import com.ctreber.acearth.plugins.markers.Marker;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.DiagramType;
import net.sourceforge.plantuml.PSystemBasicFactory;
import net.sourceforge.plantuml.acearth.PSystemXearth;

public class PSystemXearthFactory
implements PSystemBasicFactory {
    private PSystemXearth system;
    private final Map<String, String> config = new LinkedHashMap<String, String>();
    private final List<Marker> markers = new ArrayList<Marker>();
    private int width;
    private int height;

    public void init(String string) {
        this.width = 512;
        this.height = 512;
        this.config.clear();
    }

    private void extractDimension(String string) {
        Pattern pattern = Pattern.compile("\\((\\d+),(\\d+)\\)");
        Matcher matcher = pattern.matcher(string);
        boolean bl = matcher.find();
        if (bl) {
            this.width = Integer.parseInt(matcher.group(1));
            this.height = Integer.parseInt(matcher.group(2));
        }
    }

    public PSystemXearth getSystem() {
        return this.system;
    }

    public boolean executeLine(String string) {
        if (this.system == null && string.startsWith("xearth")) {
            this.extractDimension(string);
            this.system = new PSystemXearth(this.width, this.height, this.config, this.markers);
            return true;
        }
        if (this.system == null) {
            return false;
        }
        if (string.startsWith("#") || string.startsWith("'")) {
            return true;
        }
        Pattern pattern = Pattern.compile("(\\w+)\\s*=\\s*(.*)");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            this.config.put(matcher.group(1), matcher.group(2));
            return true;
        }
        try {
            Marker marker = Marker.loadMarkerFile(string);
            if (marker != null) {
                this.markers.add(marker);
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return false;
    }

    public DiagramType getDiagramType() {
        return DiagramType.UML;
    }
}

