/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram2.command;

import java.util.List;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UniqueSequence;
import net.sourceforge.plantuml.activitydiagram2.ActivityDiagram2;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines;
import net.sourceforge.plantuml.command.Position;
import net.sourceforge.plantuml.command.note.CommandNote;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandMultilinesNoteActivity2
extends CommandMultilines<ActivityDiagram2>
implements CommandNote {
    public CommandMultilinesNoteActivity2(ActivityDiagram2 activityDiagram2) {
        super(activityDiagram2, "(?i)^note\\s+(right|left|top|bottom)\\s*(#\\w+)?\\s*$");
    }

    @Override
    public String getPatternEnd() {
        return "(?i)^end ?note$";
    }

    @Override
    public final CommandExecutionResult execute(List<String> list) {
        Link link;
        List<String> list2 = StringUtils.getSplit(this.getStartingPattern(), list.get(0).trim());
        String string = list2.get(0);
        IEntity iEntity = ((ActivityDiagram2)this.getSystem()).getLastEntityConsulted();
        if (iEntity == null) {
            return CommandExecutionResult.error("No activity defined");
        }
        Display display = new Display(list.subList(1, list.size() - 1)).removeEmptyColumns();
        ILeaf iLeaf = ((ActivityDiagram2)this.getSystem()).createLeaf(UniqueSequence.getCode("GMN"), display, LeafType.NOTE);
        iLeaf.setSpecificBackcolor(HtmlColorUtils.getColorIfValid(list2.get(1)));
        Position position = Position.valueOf(string.toUpperCase()).withRankdir(((ActivityDiagram2)this.getSystem()).getRankdir());
        LinkType linkType = new LinkType(LinkDecor.NONE, LinkDecor.NONE).getDashed();
        if (position == Position.RIGHT) {
            link = new Link(iEntity, iLeaf, linkType, null, 1);
        } else if (position == Position.LEFT) {
            link = new Link(iLeaf, iEntity, linkType, null, 1);
        } else if (position == Position.BOTTOM) {
            link = new Link(iEntity, iLeaf, linkType, null, 2);
        } else if (position == Position.TOP) {
            link = new Link(iLeaf, iEntity, linkType, null, 2);
        } else {
            throw new IllegalArgumentException();
        }
        ((ActivityDiagram2)this.getSystem()).addLink(link);
        return CommandExecutionResult.ok();
    }
}

