/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.code;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.code.StringCompressor;

public class ArobaseStringCompressor
implements StringCompressor {
    private static final Pattern p = Pattern.compile("(?s)(?i)^\\s*(@startuml[^\\n\\r]*)?\\s*(.*?)\\s*(@enduml)?\\s*$");

    public String compress(String string) throws IOException {
        Matcher matcher = p.matcher(string);
        if (matcher.find()) {
            return this.clean(matcher.group(2));
        }
        return "";
    }

    public String decompress(String string) throws IOException {
        String string2 = this.clean(string);
        if (string2.startsWith("@start")) {
            return string2;
        }
        string2 = "@startuml\n" + string2;
        if (!string2.endsWith("\n")) {
            string2 = string2 + "\n";
        }
        string2 = string2 + "@enduml";
        return string2;
    }

    private String clean(String string) {
        string = string.trim();
        string = this.clean1(string);
        string = string.replaceAll("@enduml[^\\n\\r]*", "");
        string = string.replaceAll("@startuml[^\\n\\r]*", "");
        string = string.trim();
        return string;
    }

    private String clean1(String string) {
        Matcher matcher = p.matcher(string);
        if (matcher.matches()) {
            return matcher.group(2);
        }
        return string;
    }
}

