/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.BlockMember;
import net.sourceforge.plantuml.cucadiagram.BodyEnhanced2;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.cucadiagram.MemberImpl;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.skin.VisibilityModifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bodier {
    private final List<String> rawBody = new ArrayList<String>();
    private final Set<VisibilityModifier> hides;
    private final LeafType type;
    private List<Member> methodsToDisplay;
    private List<Member> fieldsToDisplay;
    private final boolean manageModifier;
    private List<Url> urls = Collections.emptyList();

    public Bodier(LeafType leafType, Set<VisibilityModifier> set) {
        this.hides = set;
        this.type = leafType;
        this.manageModifier = leafType == null ? false : leafType.manageModifier();
    }

    public void addFieldOrMethod(String string) {
        this.methodsToDisplay = null;
        this.fieldsToDisplay = null;
        this.rawBody.add(string);
    }

    public boolean isBodyEnhanced() {
        for (String string : this.rawBody) {
            if (!BodyEnhanced2.isBlockSeparator(string)) continue;
            return true;
        }
        return false;
    }

    public BlockMember getBodyEnhanced() {
        return new BlockMember(){

            public TextBlock asTextBlock(FontParam fontParam, ISkinParam iSkinParam) {
                BodyEnhanced2 bodyEnhanced2 = new BodyEnhanced2(Bodier.this.rawBody, fontParam, iSkinParam, Bodier.this.manageModifier);
                Bodier.this.urls = bodyEnhanced2.getUrls();
                return bodyEnhanced2;
            }
        };
    }

    private LeafType getEntityType() {
        return this.type;
    }

    private boolean isMethod(String string) {
        if (this.getEntityType() == LeafType.ABSTRACT_CLASS || this.getEntityType() == LeafType.CLASS || this.getEntityType() == LeafType.INTERFACE || this.getEntityType() == LeafType.ENUM) {
            return StringUtils.isMethod(string);
        }
        return false;
    }

    public List<Member> getMethodsToDisplay() {
        if (this.methodsToDisplay == null) {
            this.methodsToDisplay = new ArrayList<Member>();
            for (int i = 0; i < this.rawBody.size(); ++i) {
                String string = this.rawBody.get(i);
                if (!this.isMethod(i, this.rawBody) || string.length() == 0 && this.methodsToDisplay.size() == 0) continue;
                MemberImpl memberImpl = new MemberImpl(string, true, this.manageModifier);
                if (this.hides != null && this.hides.contains((Object)memberImpl.getVisibilityModifier())) continue;
                this.methodsToDisplay.add(memberImpl);
            }
            this.removeFinalEmptyMembers(this.methodsToDisplay);
        }
        return Collections.unmodifiableList(this.methodsToDisplay);
    }

    private boolean isMethod(int n, List<String> list) {
        if (n > 0 && n < list.size() - 1 && list.get(n).length() == 0 && this.isMethod(list.get(n - 1)) && this.isMethod(list.get(n + 1))) {
            return true;
        }
        return this.isMethod(list.get(n));
    }

    public List<Member> getFieldsToDisplay() {
        if (this.fieldsToDisplay == null) {
            this.fieldsToDisplay = new ArrayList<Member>();
            for (String string : this.rawBody) {
                if (this.isMethod(string) || string.length() == 0 && this.fieldsToDisplay.size() == 0) continue;
                MemberImpl memberImpl = new MemberImpl(string, false, this.manageModifier);
                if (this.hides != null && this.hides.contains((Object)memberImpl.getVisibilityModifier())) continue;
                this.fieldsToDisplay.add(memberImpl);
            }
            this.removeFinalEmptyMembers(this.fieldsToDisplay);
        }
        return Collections.unmodifiableList(this.fieldsToDisplay);
    }

    private void removeFinalEmptyMembers(List<Member> list) {
        while (list.size() > 0 && list.get(list.size() - 1).getDisplay(false).trim().length() == 0) {
            list.remove(list.size() - 1);
        }
    }

    public List<Url> getUrls() {
        return Collections.unmodifiableList(this.urls);
    }
}

