/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.util.Map;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cucadiagram.EntityUtils;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.ILeaf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Code
implements Comparable<Code> {
    private final String code;

    private Code(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.code = string;
    }

    public static Code of(String string) {
        if (string == null) {
            return null;
        }
        return new Code(string);
    }

    public final String getCode() {
        return this.code;
    }

    public String toString() {
        return this.code;
    }

    public int hashCode() {
        return this.code.hashCode();
    }

    public boolean equals(Object object) {
        Code code = (Code)object;
        return this.code.equals(code.code);
    }

    public Code addSuffix(String string) {
        return new Code(this.code + string);
    }

    @Override
    public int compareTo(Code code) {
        return this.code.compareTo(code.code);
    }

    public Code eventuallyRemoveStartingAndEndingDoubleQuote() {
        return Code.of(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(this.code));
    }

    public final String getNamespace(Map<Code, ILeaf> map, String string) {
        int n;
        String string2 = this.getCode();
        if (string == null) {
            throw new IllegalArgumentException();
        }
        do {
            if ((n = string2.lastIndexOf(string)) != -1) continue;
            return null;
        } while (map.containsKey(Code.of(string2 = string2.substring(0, n))));
        return string2;
    }

    public final Code getShortName(Map<Code, ILeaf> map, String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        String string2 = this.getCode();
        String string3 = this.getNamespace(map, string);
        if (string3 == null) {
            return Code.of(string2);
        }
        return Code.of(string2.substring(string3.length() + string.length()));
    }

    public final Code getFullyQualifiedCode(IGroup iGroup, String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        String string2 = this.getCode();
        if (string2.startsWith(string)) {
            return Code.of(string2.substring(string.length()));
        }
        if (string2.contains(string)) {
            return Code.of(string2);
        }
        if (EntityUtils.groupRoot(iGroup)) {
            return Code.of(string2);
        }
        String string3 = iGroup.zgetNamespace();
        if (string3 == null) {
            return Code.of(string2);
        }
        return Code.of(string3 + string + string2);
    }
}

