/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.TextBlockWidth;
import net.sourceforge.plantuml.skin.VisibilityModifier;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.ugraphic.AbstractPlacementStrategy;
import net.sourceforge.plantuml.ugraphic.PlacementStrategyVisibility;
import net.sourceforge.plantuml.ugraphic.PlacementStrategyY1Y2Center;
import net.sourceforge.plantuml.ugraphic.PlacementStrategyY1Y2Left;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULayoutGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodsOrFieldsArea
implements TextBlockWidth,
TextBlock {
    private final UFont font;
    private final ISkinParam skinParam;
    private final HtmlColor color;
    private final Rose rose = new Rose();
    private final List<Member> members = new ArrayList<Member>();
    private final HorizontalAlignement align;

    public MethodsOrFieldsArea(List<Member> list, FontParam fontParam, ISkinParam iSkinParam) {
        this(list, fontParam, iSkinParam, HorizontalAlignement.LEFT);
    }

    public MethodsOrFieldsArea(List<Member> list, FontParam fontParam, ISkinParam iSkinParam, HorizontalAlignement horizontalAlignement) {
        this.align = horizontalAlignement;
        this.skinParam = iSkinParam;
        this.font = iSkinParam.getFont(fontParam, null);
        this.color = this.rose.getFontColor(iSkinParam, fontParam);
        this.members.addAll(list);
    }

    private boolean hasSmallIcon() {
        if (this.skinParam.classAttributeIconSize() == 0) {
            return false;
        }
        for (Member member : this.members) {
            if (member.getVisibilityModifier() == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        double d = 0.0;
        if (this.hasSmallIcon()) {
            d = this.skinParam.getCircledCharacterRadius() + 3;
        }
        double d2 = 0.0;
        double d3 = 0.0;
        for (Member member : this.members) {
            TextBlock textBlock = this.createTextBlock(member);
            Dimension2D dimension2D = textBlock.calculateDimension(stringBounder);
            d2 = Math.max(dimension2D.getWidth(), d2);
            d3 += dimension2D.getHeight();
        }
        return new Dimension2DDouble(d2 += d, d3);
    }

    private TextBlock createTextBlock(Member member) {
        boolean bl = this.skinParam.classAttributeIconSize() == 0;
        String string = member.getDisplay(bl);
        FontConfiguration fontConfiguration = new FontConfiguration(this.font, this.color);
        if (member.isAbstract()) {
            fontConfiguration = fontConfiguration.italic();
        }
        if (member.isStatic()) {
            fontConfiguration = fontConfiguration.underline();
        }
        TextBlock textBlock = TextBlockUtils.create(Display.getWithNewlines(string), fontConfiguration, this.align, this.skinParam);
        return new TextBlockTracer(member, textBlock);
    }

    private TextBlock getUBlock(VisibilityModifier visibilityModifier) {
        if (visibilityModifier == null) {
            return new TextBlock(){

                @Override
                public void drawU(UGraphic uGraphic, double d, double d2) {
                }

                @Override
                public Dimension2D calculateDimension(StringBounder stringBounder) {
                    return new Dimension2DDouble(1.0, 1.0);
                }

                @Override
                public List<Url> getUrls() {
                    return Collections.emptyList();
                }
            };
        }
        HtmlColor htmlColor = visibilityModifier.getBackground() == null ? null : this.rose.getHtmlColor(this.skinParam, visibilityModifier.getBackground());
        HtmlColor htmlColor2 = this.rose.getHtmlColor(this.skinParam, visibilityModifier.getForeground());
        TextBlock textBlock = visibilityModifier.getUBlock(this.skinParam.classAttributeIconSize(), htmlColor2, htmlColor);
        return textBlock;
    }

    @Override
    public TextBlock asTextBlock(double d) {
        return new TextBlock(){

            @Override
            public void drawU(UGraphic uGraphic, double d, double d2) {
                MethodsOrFieldsArea.this.drawU(uGraphic, d, d2);
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return MethodsOrFieldsArea.this.calculateDimension(stringBounder);
            }

            @Override
            public List<Url> getUrls() {
                return Collections.emptyList();
            }
        };
    }

    @Override
    public void drawU(UGraphic uGraphic, double d, double d2) {
        ULayoutGroup uLayoutGroup;
        Dimension2D dimension2D = this.calculateDimension(uGraphic.getStringBounder());
        if (this.hasSmallIcon()) {
            uLayoutGroup = new ULayoutGroup(new PlacementStrategyVisibility(uGraphic.getStringBounder(), this.skinParam.getCircledCharacterRadius() + 3));
            for (Member member : this.members) {
                TextBlock textBlock = this.createTextBlock(member);
                VisibilityModifier visibilityModifier = member.getVisibilityModifier();
                uLayoutGroup.add(this.getUBlock(visibilityModifier));
                uLayoutGroup.add(textBlock);
            }
        } else {
            AbstractPlacementStrategy abstractPlacementStrategy;
            if (this.align == HorizontalAlignement.LEFT) {
                abstractPlacementStrategy = new PlacementStrategyY1Y2Left(uGraphic.getStringBounder());
            } else if (this.align == HorizontalAlignement.CENTER) {
                abstractPlacementStrategy = new PlacementStrategyY1Y2Center(uGraphic.getStringBounder());
            } else {
                throw new IllegalStateException();
            }
            uLayoutGroup = new ULayoutGroup(abstractPlacementStrategy);
            for (Member member : this.members) {
                TextBlock textBlock = this.createTextBlock(member);
                uLayoutGroup.add(textBlock);
            }
        }
        uLayoutGroup.drawU(uGraphic, d, d2, dimension2D.getWidth(), dimension2D.getHeight());
    }

    @Override
    public List<Url> getUrls() {
        return Collections.emptyList();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TextBlockTracer
    implements TextBlock {
        private final TextBlock bloc;
        private final Url url;

        public TextBlockTracer(Member member, TextBlock textBlock) {
            this.bloc = textBlock;
            this.url = member.getUrl();
        }

        @Override
        public void drawU(UGraphic uGraphic, double d, double d2) {
            if (this.url != null) {
                uGraphic.startUrl(this.url);
            }
            this.bloc.drawU(uGraphic, d, d2);
            if (this.url != null) {
                uGraphic.closeAction();
            }
        }

        @Override
        public List<Url> getUrls() {
            if (this.url != null) {
                return Collections.singletonList(this.url);
            }
            return Collections.emptyList();
        }

        @Override
        public Dimension2D calculateDimension(StringBounder stringBounder) {
            Dimension2D dimension2D = this.bloc.calculateDimension(stringBounder);
            return dimension2D;
        }
    }
}

