/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.dot;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cucadiagram.dot.Graphviz;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizUtils;
import net.sourceforge.plantuml.cucadiagram.dot.ProcessRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractGraphviz
implements Graphviz {
    private final File dotExe;
    private final String dotString;
    private final String[] type;

    static boolean isWindows() {
        return File.separatorChar == '\\';
    }

    AbstractGraphviz(String string, String ... stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException();
        }
        this.dotExe = this.searchDotExe();
        this.dotString = string;
        this.type = stringArray;
    }

    private File searchDotExe() {
        if (OptionFlags.getInstance().getDotExecutable() == null) {
            String string = GraphvizUtils.getenvGraphvizDot();
            if (string == null) {
                return this.specificDotExe();
            }
            return new File(string);
        }
        return new File(OptionFlags.getInstance().getDotExecutable());
    }

    protected abstract File specificDotExe();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void createFile(OutputStream outputStream) throws IOException, InterruptedException {
        if (this.dotString == null) {
            throw new IllegalArgumentException();
        }
        if (this.illegalDotExe()) {
            throw new IllegalStateException();
        }
        String string = this.getCommandLine();
        ProcessRunner processRunner = null;
        try {
            Log.info("Starting Graphviz process " + string);
            Log.info("DotString size: " + this.dotString.length());
            processRunner = new ProcessRunner(string);
            processRunner.run(this.dotString.getBytes(), outputStream);
            Log.info("Ending process ok");
        }
        catch (InterruptedException interruptedException) {
            Log.error("Interrupted");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Log.error("Error: " + throwable);
            Log.error("The command was " + string);
            Log.error("");
            Log.error("Try java -jar plantuml.jar -testdot to figure out the issue");
            Log.error("");
        }
        finally {
            Log.info("Ending Graphviz process");
        }
        if (OptionFlags.getInstance().isCheckDotError() && processRunner != null && processRunner.getError().length() > 0) {
            Log.error("GraphViz error stream : " + processRunner.getError());
            if (OptionFlags.getInstance().isCheckDotError()) {
                throw new IllegalStateException("Dot error " + processRunner.getError());
            }
        }
        if (OptionFlags.getInstance().isCheckDotError() && processRunner != null && processRunner.getOut().length() > 0) {
            Log.error("GraphViz out stream : " + processRunner.getOut());
            if (OptionFlags.getInstance().isCheckDotError()) {
                throw new IllegalStateException("Dot out " + processRunner.getOut());
            }
        }
    }

    private boolean illegalDotExe() {
        return this.dotExe == null || !this.dotExe.isFile() || !this.dotExe.canRead();
    }

    @Override
    public final String dotVersion() throws IOException, InterruptedException {
        String string = this.getCommandLineVersion();
        return this.executeCmd(string);
    }

    @Override
    public String testFile(String string, String string2) throws IOException, InterruptedException {
        String string3 = this.getCommandLine() + "-o" + string2 + " " + string;
        return this.executeCmd(string3);
    }

    private String executeCmd(String string) throws IOException, InterruptedException {
        ProcessRunner processRunner = new ProcessRunner(string);
        processRunner.run(null, null);
        StringBuilder stringBuilder = new StringBuilder();
        if (StringUtils.isNotEmpty(processRunner.getOut())) {
            stringBuilder.append(processRunner.getOut());
        }
        if (StringUtils.isNotEmpty(processRunner.getError())) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(processRunner.getError());
        }
        return stringBuilder.toString().replace('\n', ' ').trim();
    }

    abstract String getCommandLine();

    abstract String getCommandLineVersion();

    @Override
    public final File getDotExe() {
        return this.dotExe;
    }

    protected final void appendImageType(StringBuilder stringBuilder) {
        for (String string : this.type) {
            stringBuilder.append(" -T" + string + " ");
        }
    }

    public final String getDotString() {
        return this.dotString;
    }

    public final List<String> getType() {
        return Arrays.asList(this.type);
    }
}

