/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.dot;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cucadiagram.dot.AbstractGraphviz;
import net.sourceforge.plantuml.cucadiagram.dot.Graphviz;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizLinux;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizWindows;
import net.sourceforge.plantuml.cucadiagram.dot.OS;
import net.sourceforge.plantuml.cucadiagram.dot.OSLinux;
import net.sourceforge.plantuml.cucadiagram.dot.OSWindows;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphvizUtils {
    private static final String TMP_TEST_FILENAME = "testdottmp42";
    private static int DOT_VERSION_LIMIT = 226;
    private static String dotVersion = null;

    private static boolean isWindows() {
        return File.separatorChar == '\\';
    }

    @Deprecated
    public static Graphviz create(String string, String ... stringArray) {
        AbstractGraphviz abstractGraphviz = GraphvizUtils.isWindows() ? new GraphvizWindows(string, stringArray) : new GraphvizLinux(string, stringArray);
        return abstractGraphviz;
    }

    public static File getDotExe() {
        return GraphvizUtils.create(null, "png").getDotExe();
    }

    public static String getenvGraphvizDot() {
        String string = System.getProperty("GRAPHVIZ_DOT");
        if (StringUtils.isNotEmpty(string)) {
            return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string);
        }
        String string2 = System.getenv("GRAPHVIZ_DOT");
        if (StringUtils.isNotEmpty(string2)) {
            return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string2);
        }
        return null;
    }

    public static String getenvLogData() {
        String string = System.getProperty("PLANTUML_LOGDATA");
        if (StringUtils.isNotEmpty(string)) {
            return string;
        }
        return System.getenv("PLANTUML_LOGDATA");
    }

    public static String dotVersion() throws IOException, InterruptedException {
        if (dotVersion == null) {
            dotVersion = GraphvizUtils.getDotExe() == null ? "Error: Dot not installed" : (!GraphvizUtils.getDotExe().exists() ? "Error: " + GraphvizUtils.getDotExe().getAbsolutePath() + " does not exist" : (!GraphvizUtils.getDotExe().isFile() ? "Error: " + GraphvizUtils.getDotExe().getAbsolutePath() + " is not a file" : (!GraphvizUtils.getDotExe().canRead() ? "Error: " + GraphvizUtils.getDotExe().getAbsolutePath() + " cannot be read" : GraphvizUtils.create(null, "png").dotVersion())));
        }
        return dotVersion;
    }

    static int retrieveVersion(String string) {
        if (string == null) {
            return -1;
        }
        Pattern pattern = Pattern.compile("\\s([12].\\d\\d)\\D");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.find()) {
            return -1;
        }
        return Integer.parseInt(matcher.group(1).replaceAll("\\.", ""));
    }

    public static int getDotVersion() throws IOException, InterruptedException {
        return GraphvizUtils.retrieveVersion(GraphvizUtils.dotVersion());
    }

    public static List<String> getTestDotStrings(boolean bl) {
        ArrayList<String> arrayList;
        block17: {
            String string = "";
            String string2 = "";
            if (bl) {
                string = "<b><color:red>";
                string2 = "<b>";
            }
            arrayList = new ArrayList<String>();
            String string3 = GraphvizUtils.getenvGraphvizDot();
            if (string3 == null) {
                arrayList.add("The environment variable GRAPHVIZ_DOT has not been set");
            } else {
                arrayList.add("The environment variable GRAPHVIZ_DOT has been set to " + string3);
            }
            File file = GraphvizUtils.getDotExe();
            arrayList.add("Dot executable is " + file);
            boolean bl2 = true;
            if (file == null) {
                arrayList.add(string + "Error: No dot executable found");
                bl2 = false;
            } else if (!file.exists()) {
                arrayList.add(string + "Error: file does not exist");
                bl2 = false;
            } else if (!file.isFile()) {
                arrayList.add(string + "Error: not a valid file");
                bl2 = false;
            } else if (!file.canRead()) {
                arrayList.add(string + "Error: cannot be read");
                bl2 = false;
            }
            if (bl2) {
                try {
                    String string4 = GraphvizUtils.dotVersion();
                    arrayList.add("Dot version: " + string4);
                    int n = GraphvizUtils.getDotVersion();
                    if (n == -1) {
                        arrayList.add("Warning : cannot determine dot version");
                        break block17;
                    }
                    if (n < DOT_VERSION_LIMIT) {
                        arrayList.add(string2 + "Warning : Your dot installation seems old");
                        arrayList.add(string2 + "Some diagrams may have issues");
                        break block17;
                    }
                    String string5 = GraphvizUtils.getTestCreateSimpleFile();
                    if (string5 == null) {
                        arrayList.add(string2 + "Installation seems OK. PNG generation OK");
                        break block17;
                    }
                    arrayList.add(string + string5);
                }
                catch (Exception exception) {
                    arrayList.add(string + exception.toString());
                    exception.printStackTrace();
                }
            } else {
                arrayList.add("Error: only sequence diagrams will be generated");
            }
        }
        return Collections.unmodifiableList(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getTestCreateSimpleFile() throws IOException, InterruptedException {
        Graphviz graphviz = GraphvizUtils.create("", "png");
        File file = new File("testdottmp42.dot");
        File file2 = new File("testdottmp42.png");
        file.delete();
        file2.delete();
        try {
            PrintWriter printWriter = new PrintWriter(file);
            printWriter.println("digraph foo { test; }");
            printWriter.close();
            graphviz.testFile(file.getName(), file2.getName());
            file.delete();
            if (!file2.exists()) {
                String string = "Error: dot cannot generated PNG file. Check you dot installation.";
                return string;
            }
            if (file2.length() == 0L) {
                String string = "Error: dot generates empty PNG file. Check you dot installation.";
                return string;
            }
            try {
                ImageIO.read(file2);
            }
            catch (IOException iOException) {
                String string = "Error: dot generates unreadable PNG file. Check you dot installation.";
                file2.delete();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            file2.delete();
        }
    }

    public static OS getOS() {
        if (GraphvizUtils.isWindows()) {
            return new OSWindows();
        }
        return new OSLinux();
    }
}

