/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.dot;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.cucadiagram.dot.AbstractGraphviz;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GraphvizWindows
extends AbstractGraphviz {
    @Override
    protected File specificDotExe() {
        File file = GraphvizWindows.searchInDir(new File("c:/Program Files"));
        if (file != null) {
            return file;
        }
        File file2 = GraphvizWindows.searchInDir(new File("c:/Program Files (x86)"));
        if (file2 != null) {
            return file2;
        }
        return null;
    }

    private static File searchInDir(File file) {
        if (!file.exists() || !file.isDirectory()) {
            return null;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file2 : file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() && file.getName().startsWith("Graphviz");
            }
        })) {
            File file3 = new File(new File(file2, "bin"), "dot.exe");
            if (!file3.exists() || !file3.canRead()) continue;
            arrayList.add(file3.getAbsoluteFile());
        }
        return GraphvizWindows.higherVersion(arrayList);
    }

    static File higherVersion(List<File> list) {
        if (list.size() == 0) {
            return null;
        }
        Collections.sort(list, Collections.reverseOrder());
        return list.get(0);
    }

    GraphvizWindows(String string, String ... stringArray) {
        super(string, stringArray);
    }

    @Override
    String getCommandLine() {
        StringBuilder stringBuilder = new StringBuilder();
        GraphvizWindows.appendDoubleQuoteOnWindows(stringBuilder);
        stringBuilder.append(this.getDotExe().getAbsolutePath());
        GraphvizWindows.appendDoubleQuoteOnWindows(stringBuilder);
        this.appendImageType(stringBuilder);
        return stringBuilder.toString();
    }

    private static void appendDoubleQuoteOnWindows(StringBuilder stringBuilder) {
        stringBuilder.append('\"');
    }

    @Override
    String getCommandLineVersion() {
        StringBuilder stringBuilder = new StringBuilder();
        GraphvizWindows.appendDoubleQuoteOnWindows(stringBuilder);
        stringBuilder.append(this.getDotExe().getAbsolutePath());
        GraphvizWindows.appendDoubleQuoteOnWindows(stringBuilder);
        stringBuilder.append(" -V");
        return stringBuilder.toString();
    }
}

