/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.plantuml.cucadiagram.Bodier;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.GroupRoot;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.entity.EntityImpl;
import net.sourceforge.plantuml.skin.VisibilityModifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityFactory {
    private final Map<Code, ILeaf> leafs = new Protect(new LinkedHashMap());
    private final List<Link> links = new ArrayList<Link>();
    private final Map<Code, IGroup> groups = new Protect(new LinkedHashMap());
    private final IGroup rootGroup = new GroupRoot(this);

    public ILeaf createLeaf(Code code, Display display, LeafType leafType, IGroup iGroup, Set<VisibilityModifier> set) {
        if (leafType == null) {
            throw new IllegalArgumentException();
        }
        Bodier bodier = new Bodier(leafType, set);
        EntityImpl entityImpl = new EntityImpl(this, code, bodier, iGroup, leafType);
        entityImpl.setDisplay(display);
        return entityImpl;
    }

    public IGroup createGroup(Code code, Display display, String string, GroupType groupType, IGroup iGroup, Set<VisibilityModifier> set) {
        if (groupType == null) {
            throw new IllegalArgumentException();
        }
        Bodier bodier = new Bodier(null, set);
        EntityImpl entityImpl = new EntityImpl(this, code, bodier, iGroup, groupType, string);
        if (display != null) {
            entityImpl.setDisplay(display);
        }
        return entityImpl;
    }

    public IGroup getRootGroup() {
        return this.rootGroup;
    }

    public final Map<Code, ILeaf> getLeafs() {
        return Collections.unmodifiableMap(this.leafs);
    }

    public void addLeaf(ILeaf iLeaf) {
        this.leafs.put(iLeaf.getCode(), iLeaf);
    }

    void removeLeaf(Code code) {
        IEntity iEntity = this.leafs.remove(code);
        if (iEntity == null) {
            throw new IllegalArgumentException();
        }
    }

    public void addGroup(IGroup iGroup) {
        this.groups.put(iGroup.getCode(), iGroup);
    }

    void removeGroup(Code code) {
        IEntity iEntity = this.groups.remove(code);
        if (iEntity == null) {
            throw new IllegalArgumentException();
        }
    }

    public final Map<Code, IGroup> getGroups() {
        return Collections.unmodifiableMap(this.groups);
    }

    public final List<Link> getLinks() {
        return Collections.unmodifiableList(this.links);
    }

    public void addLink(Link link) {
        this.links.add(link);
    }

    public void removeLink(Link link) {
        boolean bl = this.links.remove(link);
        if (!bl) {
            throw new IllegalArgumentException();
        }
    }

    public IGroup muteToGroup(Code code, String string, GroupType groupType, IGroup iGroup) {
        ILeaf iLeaf = this.getLeafs().get(code);
        ((EntityImpl)iLeaf).muteToGroup(string, groupType, iGroup);
        IGroup iGroup2 = (IGroup)((Object)iLeaf);
        this.removeLeaf(code);
        return iGroup2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Protect<O>
    implements Map<Code, O> {
        private final Map<Code, O> m;

        public Protect(Map<Code, O> map) {
            this.m = map;
        }

        @Override
        public O remove(Object object) {
            if (!(object instanceof Code)) {
                throw new IllegalArgumentException();
            }
            return this.m.remove(object);
        }

        @Override
        public O get(Object object) {
            if (!(object instanceof Code)) {
                throw new IllegalArgumentException();
            }
            return this.m.get(object);
        }

        @Override
        public Set<Code> keySet() {
            return this.m.keySet();
        }

        @Override
        public void putAll(Map<? extends Code, ? extends O> map) {
            this.m.putAll(map);
        }

        @Override
        public boolean containsKey(Object object) {
            if (!(object instanceof Code)) {
                throw new IllegalArgumentException();
            }
            return this.m.containsKey(object);
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public O put(Code code, O o) {
            if (!(code instanceof Code)) {
                throw new IllegalArgumentException();
            }
            return this.m.put(code, o);
        }

        @Override
        public boolean containsValue(Object object) {
            return this.m.containsValue(object);
        }

        @Override
        public Set<Map.Entry<Code, O>> entrySet() {
            return this.m.entrySet();
        }

        @Override
        public Collection<O> values() {
            return this.m.values();
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public int size() {
            return this.m.size();
        }
    }
}

