/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ditaa;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.imageio.ImageIO;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.CMapData;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import org.stathissideris.ascii2image.core.ConversionOptions;
import org.stathissideris.ascii2image.core.ProcessingOptions;
import org.stathissideris.ascii2image.graphics.BitmapRenderer;
import org.stathissideris.ascii2image.graphics.Diagram;
import org.stathissideris.ascii2image.text.TextGrid;

public class PSystemDitaa
extends AbstractPSystem {
    private final TextGrid grid = new TextGrid();
    private final ProcessingOptions processingOptions = new ProcessingOptions();
    private final boolean dropShadows;

    public PSystemDitaa(String string, boolean bl, boolean bl2) throws UnsupportedEncodingException {
        this.dropShadows = bl2;
        this.grid.initialiseWithText(string, null);
        this.processingOptions.setPerformSeparationOfCommonEdges(bl);
    }

    public String getDescription() {
        return "(Ditaa)";
    }

    public void exportDiagram(OutputStream outputStream, CMapData cMapData, int n, FileFormatOption fileFormatOption) throws IOException {
        if (fileFormatOption.getFileFormat() == FileFormat.PNG) {
            ConversionOptions conversionOptions = new ConversionOptions();
            conversionOptions.setDropShadows(this.dropShadows);
            Diagram diagram = new Diagram(this.grid, conversionOptions, this.processingOptions);
            BufferedImage bufferedImage = (BufferedImage)new BitmapRenderer().renderToImage(diagram, conversionOptions.renderingOptions);
            ImageIO.write((RenderedImage)bufferedImage, "png", outputStream);
        } else if (fileFormatOption.getFileFormat() == FileFormat.ATXT) {
            outputStream.write(this.getSource().getPlainString().getBytes());
        } else {
            throw new UnsupportedOperationException(fileFormatOption.getFileFormat().toString());
        }
    }
}

