/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.flowdiagram;

import java.awt.geom.Dimension2D;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.golem.Tile;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityBox
implements TextBlock {
    private static final int CORNER = 25;
    private static final int MARGIN = 10;
    private final Tile tile;
    private final String id;
    private final String label;
    private final TextBlock tb;

    public ActivityBox(Tile tile, String string, String string2) {
        this.tile = tile;
        this.id = string;
        this.label = string2;
        UFont uFont = new UFont("Serif", 0, 14);
        FontConfiguration fontConfiguration = new FontConfiguration(uFont, HtmlColorUtils.BLACK);
        this.tb = TextBlockUtils.create(Display.asList(string2), fontConfiguration, HorizontalAlignement.LEFT, new SpriteContainerEmpty());
    }

    public Tile getTile() {
        return this.tile;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    @Override
    public void drawU(UGraphic uGraphic, double d, double d2) {
        Dimension2D dimension2D = this.calculateDimension(uGraphic.getStringBounder());
        double d3 = dimension2D.getWidth();
        double d4 = dimension2D.getHeight();
        URectangle uRectangle = new URectangle(d3, d4, 25.0, 25.0);
        uGraphic.getParam().setColor(HtmlColorUtils.getColorIfValid("#A80036"));
        uGraphic.getParam().setBackcolor(HtmlColorUtils.getColorIfValid("#FEFECE"));
        uGraphic.getParam().setStroke(new UStroke(1.5));
        uGraphic.draw(d, d2, uRectangle);
        uGraphic.getParam().setStroke(new UStroke(1.0));
        this.tb.drawU(uGraphic, d + 10.0, d2 + 10.0);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.tb.calculateDimension(stringBounder);
        return Dimension2DDouble.delta(dimension2D, 20.0, 20.0);
    }

    @Override
    public List<Url> getUrls() {
        return this.tb.getUrls();
    }
}

