/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.flowdiagram;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.CMapData;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.UmlDiagramInfo;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.flowdiagram.ActivityBox;
import net.sourceforge.plantuml.golem.MinMax;
import net.sourceforge.plantuml.golem.Path;
import net.sourceforge.plantuml.golem.Position;
import net.sourceforge.plantuml.golem.Tile;
import net.sourceforge.plantuml.golem.TileArea;
import net.sourceforge.plantuml.golem.TileGeometry;
import net.sourceforge.plantuml.golem.TilesField;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGraphicUtils;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UShape;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowDiagram
extends UmlDiagram
implements TextBlock {
    private static double SINGLE_SIZE_X = 100.0;
    private static double SINGLE_SIZE_Y = 35.0;
    private TilesField field;
    private final Map<Tile, ActivityBox> tilesBoxes = new HashMap<Tile, ActivityBox>();
    private Tile lastTile;

    @Override
    public String getDescription() {
        return "Flow Diagram";
    }

    @Override
    public UmlDiagramType getUmlDiagramType() {
        return UmlDiagramType.FLOW;
    }

    public void lineSimple(TileGeometry tileGeometry, String string, String string2) {
        Tile tile;
        if (this.field == null) {
            this.field = new TilesField();
            this.tilesBoxes.clear();
            tile = this.field.getRoot();
        } else {
            tile = this.field.createTile(this.lastTile, tileGeometry);
        }
        ActivityBox activityBox = new ActivityBox(tile, string, string2);
        this.tilesBoxes.put(tile, activityBox);
        this.lastTile = tile;
    }

    public void linkSimple(TileGeometry tileGeometry, String string) {
        Tile tile = this.getTileById(string);
        this.field.addPath(this.lastTile, tile, tileGeometry);
    }

    private Tile getTileById(String string) {
        for (Map.Entry<Tile, ActivityBox> entry : this.tilesBoxes.entrySet()) {
            if (!entry.getValue().getId().equals(string)) continue;
            return entry.getKey();
        }
        throw new IllegalArgumentException(string);
    }

    @Override
    protected UmlDiagramInfo exportDiagramInternal(OutputStream outputStream, CMapData cMapData, int n, FileFormatOption fileFormatOption, List<BufferedImage> list) throws IOException {
        UGraphicUtils.writeImage(outputStream, null, fileFormatOption, new ColorMapperIdentity(), HtmlColorUtils.WHITE, this);
        return new UmlDiagramInfo();
    }

    @Override
    public void drawU(UGraphic uGraphic, double d, double d2) {
        Object object;
        Object object2;
        Object object3;
        MinMax minMax = this.getMinMax();
        d -= (double)minMax.getMinX() * SINGLE_SIZE_X;
        d2 -= (double)minMax.getMinY() * SINGLE_SIZE_Y;
        StringBounder stringBounder = uGraphic.getStringBounder();
        for (Map.Entry<Tile, ActivityBox> object4 : this.tilesBoxes.entrySet()) {
            Tile tile = object4.getKey();
            object3 = this.field.getPosition(tile);
            int n = ((Position)object3).getXmin();
            int n2 = ((Position)object3).getYmin();
            object2 = object4.getValue();
            object = ((ActivityBox)object2).calculateDimension(stringBounder);
            double d3 = SINGLE_SIZE_X * 2.0 - ((Dimension2D)object).getWidth();
            double d4 = SINGLE_SIZE_Y * 2.0 - ((Dimension2D)object).getHeight();
            ((ActivityBox)object2).drawU(uGraphic, d + (double)n * SINGLE_SIZE_X + d3 / 2.0, d2 + (double)n2 * SINGLE_SIZE_Y + d4 / 2.0);
        }
        uGraphic.getParam().setColor(HtmlColorUtils.getColorIfValid("#A80036"));
        uGraphic.getParam().setBackcolor(HtmlColorUtils.getColorIfValid("#A80036"));
        UEllipse uEllipse = new UEllipse(7.0, 7.0);
        for (Path path : this.field.getPaths()) {
            object3 = path.getStart();
            TileArea tileArea = path.getDest();
            Point2D point2D = this.movePoint(this.getCenter((TileArea)object3), ((TileArea)object3).getTile(), ((TileArea)object3).getGeometry(), stringBounder);
            object2 = this.movePoint(this.getCenter(tileArea), tileArea.getTile(), tileArea.getGeometry(), stringBounder);
            object = new ULine(((Point2D)object2).getX() - point2D.getX(), ((Point2D)object2).getY() - point2D.getY());
            uGraphic.draw(d + point2D.getX(), d2 + point2D.getY(), (UShape)object);
            uGraphic.draw(d + ((Point2D)object2).getX() - 3.0, d2 + ((Point2D)object2).getY() - 3.0, uEllipse);
        }
    }

    private Point2D getCenter(TileArea tileArea) {
        Tile tile = tileArea.getTile();
        Position position = this.field.getPosition(tile);
        double d = position.getCenterX();
        double d2 = position.getCenterY();
        return new Point2D.Double(d * SINGLE_SIZE_X, d2 * SINGLE_SIZE_Y);
    }

    private Point2D movePoint(Point2D point2D, Tile tile, TileGeometry tileGeometry, StringBounder stringBounder) {
        Dimension2D dimension2D = this.tilesBoxes.get(tile).calculateDimension(stringBounder);
        double d = dimension2D.getWidth();
        double d2 = dimension2D.getHeight();
        double d3 = point2D.getX();
        double d4 = point2D.getY();
        switch (tileGeometry) {
            case SOUTH: {
                d4 += d2 / 2.0;
                break;
            }
            case NORTH: {
                d4 -= d2 / 2.0;
                break;
            }
            case EAST: {
                d3 += d / 2.0;
                break;
            }
            case WEST: {
                d3 -= d / 2.0;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return new Point2D.Double(d3, d4);
    }

    private MinMax getMinMax() {
        MinMax minMax = new MinMax();
        for (Tile tile : this.tilesBoxes.keySet()) {
            minMax.manage(this.field.getPosition(tile));
        }
        return minMax;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        MinMax minMax = this.getMinMax();
        return new Dimension2DDouble((double)minMax.getWidth() * SINGLE_SIZE_X, (double)minMax.getHeight() * SINGLE_SIZE_Y);
    }

    @Override
    public List<Url> getUrls() {
        return Collections.emptyList();
    }
}

