/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.geom.Box;
import net.sourceforge.plantuml.geom.CollectionUtils;
import net.sourceforge.plantuml.geom.Point2DInt;
import net.sourceforge.plantuml.geom.PolylineBreakeable;
import net.sourceforge.plantuml.geom.XMoveable;
import net.sourceforge.plantuml.graph.ALink;
import net.sourceforge.plantuml.graph.ANode;
import net.sourceforge.plantuml.graph.AbstractEntityImage;
import net.sourceforge.plantuml.graph.EntityImageFactory;
import net.sourceforge.plantuml.graph.Galaxy4;
import net.sourceforge.plantuml.graph.GeneralPathFactory;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounderUtils;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.UFont;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Elastane {
    private static final int STEP = 4;
    private static final int OUTER_BOX = 20;
    private final Color red = new Color(Integer.parseInt("A80036", 16));
    private final Galaxy4 galaxy;
    private final double margin = 30.0;
    private int minX = Integer.MAX_VALUE;
    private int maxX = Integer.MIN_VALUE;
    private int minY = Integer.MAX_VALUE;
    private int maxY = Integer.MIN_VALUE;
    private final Map<ANode, Box> boxes = new LinkedHashMap<ANode, Box>();
    private final Map<ALink, PolylineBreakeable> lines = new LinkedHashMap<ALink, PolylineBreakeable>();

    Elastane(Galaxy4 galaxy4) {
        this.galaxy = galaxy4;
    }

    public void addBox(ANode aNode, int n, int n2) {
        int n3 = aNode.getRow();
        int n4 = this.galaxy.getBoard().getCol(aNode);
        Point2DInt point2DInt = this.galaxy.getMainPoint(n3, n4);
        Box box = new Box(point2DInt.getXint() - n / 2, point2DInt.getYint() - n2 / 2, n, n2);
        this.boxes.put(aNode, box);
        assert (!this.boxOverlap());
    }

    private double getCost() {
        if (this.boxOverlap()) {
            return Double.MAX_VALUE;
        }
        double d = 0.0;
        for (ALink aLink : this.galaxy.getLines().keySet()) {
            PolylineBreakeable polylineBreakeable;
            PolylineBreakeable polylineBreakeable2 = polylineBreakeable = this.lines.get(aLink);
            d += this.getLength(polylineBreakeable2);
            Box box = this.boxes.get(aLink.getNode1());
            Box box2 = this.boxes.get(aLink.getNode2());
            d += this.getCostBoxIntersect(polylineBreakeable2, box, box2);
            for (ALink aLink2 : this.galaxy.getLines().keySet()) {
                PolylineBreakeable polylineBreakeable3;
                if (aLink == aLink2 || !polylineBreakeable2.doesTouch(polylineBreakeable3 = this.lines.get(aLink2))) continue;
                d += this.getLength(polylineBreakeable3);
            }
        }
        return d;
    }

    private double getLength(PolylineBreakeable polylineBreakeable) {
        double d = polylineBreakeable.getLength();
        assert (d > 0.0);
        return Math.log(1.0 + d);
    }

    private double getCostBoxIntersect(PolylineBreakeable polylineBreakeable, Box box, Box box2) {
        double d = 0.0;
        for (Box box3 : this.boxes.values()) {
            if (box3 == box || box3 == box2 || !polylineBreakeable.intersectBox(box3)) continue;
            double d2 = polylineBreakeable.getDistance(box3);
            assert (d2 >= 0.0);
            assert (d2 != Double.MAX_VALUE);
            d += 100000.0 - d2;
        }
        return d;
    }

    private void initLines() {
        for (ALink aLink : this.galaxy.getLines().keySet()) {
            PolylineBreakeable polylineBreakeable = this.galaxy.getPolyline(aLink);
            Box box = this.boxes.get(aLink.getNode1());
            Box box2 = this.boxes.get(aLink.getNode2());
            this.lines.put(aLink, polylineBreakeable.copy(box, box2));
        }
    }

    private boolean boxOverlap() {
        ArrayList<Box> arrayList = new ArrayList<Box>();
        for (Box box : this.boxes.values()) {
            arrayList.add(box.outerBox(20));
        }
        for (int i = 0; i < arrayList.size() - 1; ++i) {
            for (int j = i + 1; j < arrayList.size(); ++j) {
                if (!((Box)arrayList.get(i)).intersectBox((Box)arrayList.get(j))) continue;
                return true;
            }
        }
        return false;
    }

    private void moveX(Collection<XMoveable> collection, int n, double d, boolean bl) {
        for (XMoveable xMoveable : collection) {
            xMoveable.moveX(n);
        }
    }

    private boolean isConcerned(ALink aLink, Collection<XMoveable> collection) {
        Box box = this.boxes.get(aLink.getNode1());
        Box box2 = this.boxes.get(aLink.getNode2());
        return collection.contains(box) && collection.contains(box2);
    }

    private boolean onePass(Collection<? extends Collection<XMoveable>> collection) {
        boolean bl = false;
        for (Collection<XMoveable> collection2 : collection) {
            double d = this.getCost();
            assert (this.reversable(d, collection2));
            this.moveX(collection2, 4, d, true);
            if (this.getCost() < d) {
                bl = true;
            } else {
                this.moveX(collection2, -4, d, false);
                this.moveX(collection2, -4, d, true);
                if (this.getCost() < d) {
                    bl = true;
                } else {
                    this.moveX(collection2, 4, d, false);
                    assert (this.getCost() == d) : "c1=" + this.getCost() + " init=" + d;
                }
            }
            assert (this.getCost() <= d);
        }
        return bl;
    }

    private boolean reversable(double d, Collection<XMoveable> collection) {
        this.moveX(collection, 4, 0.0, false);
        this.moveX(collection, -4, 0.0, false);
        assert (this.getCost() == d);
        this.moveX(collection, 4, 0.0, false);
        this.moveX(collection, -8, 0.0, false);
        this.moveX(collection, 4, 0.0, false);
        assert (this.getCost() == d);
        return true;
    }

    private Collection<XMoveable> convertANodeSet(Set<ANode> set, Map<ALink, Collection<XMoveable>> map) {
        HashSet<XMoveable> hashSet = new HashSet<XMoveable>();
        for (ANode aNode : set) {
            assert (this.boxes.get(aNode) != null);
            hashSet.add(this.boxes.get(aNode));
        }
        return hashSet;
    }

    public void draw(Graphics2D graphics2D) {
        Object object;
        Object object2;
        Object object3;
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.translate((double)(-this.minX) + 30.0, (double)(-this.minY) + 30.0);
        graphics2D.setColor(this.red);
        for (Map.Entry<ALink, PolylineBreakeable> entry : this.lines.entrySet()) {
            object3 = entry.getKey();
            object2 = (Link)object3.getUserData();
            object = new GeneralPathFactory(((Link)object2).getType());
            Box box = this.boxes.get(object3.getNode1());
            Box box2 = this.boxes.get(object3.getNode2());
            PolylineBreakeable polylineBreakeable = entry.getValue();
            Shape shape = ((GeneralPathFactory)object).getLink(polylineBreakeable, box, box2);
            String string = ((Object)((Link)object2).getLabel().get(0)).toString();
            if (string != null) {
                TextBlock textBlock = TextBlockUtils.create(Display.asList(string), new FontConfiguration(UFont.getCurrentFont(graphics2D), HtmlColorUtils.BLACK), HorizontalAlignement.LEFT, new SpriteContainerEmpty());
                textBlock.calculateDimension(StringBounderUtils.asStringBounder(graphics2D));
            }
            graphics2D.setColor(this.red);
            graphics2D.draw(shape);
        }
        graphics2D.setColor(Color.BLACK);
        for (Map.Entry<Object, Object> entry : this.boxes.entrySet()) {
            object3 = (ANode)entry.getKey();
            object2 = this.images(object3.getRow(), this.galaxy.getBoard().getCol((ANode)object3));
            assert (object2 != null);
            object = (Box)entry.getValue();
            graphics2D.translate(((Box)object).getX(), ((Box)object).getY());
            ((AbstractEntityImage)object2).draw(new ColorMapperIdentity(), graphics2D);
            graphics2D.translate(-((Box)object).getX(), -((Box)object).getY());
        }
        graphics2D.setTransform(affineTransform);
    }

    public void init() {
        boolean bl;
        this.initLines();
        HashSet<Set<ANode>> hashSet = new HashSet<Set<ANode>>();
        Collection<ANode> collection = this.galaxy.getBoard().getNodes();
        for (ANode object2 : collection) {
            for (int i = 0; i < this.galaxy.getBoard().getLinks().size(); ++i) {
                Set<ANode> bl2 = this.galaxy.getBoard().getConnectedNodes(object2, i);
                if (bl2.size() >= collection.size()) continue;
                hashSet.add(bl2);
            }
        }
        ArrayList arrayList = new ArrayList();
        HashMap<ALink, Collection<XMoveable>> hashMap = new HashMap<ALink, Collection<XMoveable>>();
        for (Map.Entry<ALink, PolylineBreakeable> polylineBreakeable : this.lines.entrySet()) {
            PolylineBreakeable polylineBreakeable2 = polylineBreakeable.getValue();
            List<XMoveable> list = polylineBreakeable2.getFreedoms();
            if (list.size() <= 0) continue;
            hashMap.put(polylineBreakeable.getKey(), list);
            arrayList.addAll(CollectionUtils.selectUpTo(list, 1));
        }
        for (Set set : hashSet) {
            arrayList.add(this.convertANodeSet(set, hashMap));
        }
        assert (this.getCost() != Double.MAX_VALUE);
        for (int i = 0; i < 3000 && (bl = this.onePass(arrayList)); ++i) {
        }
        for (Box box : this.boxes.values()) {
            this.minX = Math.min(this.minX, box.getMinX());
            this.maxX = Math.max(this.maxX, box.getMaxX());
            this.minY = Math.min(this.minY, box.getMinY());
            this.maxY = Math.max(this.maxY, box.getMaxY());
        }
        for (PolylineBreakeable polylineBreakeable : this.lines.values()) {
            this.minX = Math.min(this.minX, polylineBreakeable.getMinX());
            this.maxX = Math.max(this.maxX, polylineBreakeable.getMaxX());
            this.minY = Math.min(this.minY, polylineBreakeable.getMinY());
            this.maxY = Math.max(this.maxY, polylineBreakeable.getMaxY());
        }
    }

    private AbstractEntityImage images(int n, int n2) {
        ANode aNode = this.galaxy.getBoard().getNodeAt(n, n2);
        if (aNode == null) {
            return null;
        }
        return new EntityImageFactory().createEntityImage((IEntity)aNode.getUserData());
    }

    public Dimension2D getDimension() {
        Dimension2DDouble dimension2DDouble = new Dimension2DDouble((double)(this.maxX - this.minX) + 60.0, (double)(this.maxY - this.minY) + 60.0);
        Log.info("Dim=" + dimension2DDouble);
        return dimension2DDouble;
    }
}

