/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UHorizontalLine;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextBlockLineBefore2
implements TextBlock {
    private final TextBlock textBlock;
    private final char separator;
    private final TextBlock title;

    public TextBlockLineBefore2(TextBlock textBlock, char c, TextBlock textBlock2) {
        this.textBlock = textBlock;
        this.separator = c;
        this.title = textBlock2;
    }

    public TextBlockLineBefore2(TextBlock textBlock, char c) {
        this(textBlock, c, null);
    }

    public TextBlockLineBefore2(TextBlock textBlock) {
        this(textBlock, '_');
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.textBlock.calculateDimension(stringBounder);
        if (this.title != null) {
            Dimension2D dimension2D2 = this.title.calculateDimension(stringBounder);
            return Dimension2DDouble.atLeast(dimension2D, dimension2D2.getWidth() + 8.0, dimension2D2.getHeight());
        }
        return dimension2D;
    }

    public static void drawLine(UGraphic uGraphic, double d, UHorizontalLine uHorizontalLine, char c) {
        if (c == '=') {
            uGraphic.draw(0.0, d, uHorizontalLine);
            uGraphic.draw(0.0, d + 2.0, uHorizontalLine.blankTitle());
        } else if (c == '.') {
            uGraphic.getParam().setStroke(new UStroke(1.0, 2.0, 1.0));
            uGraphic.draw(0.0, d, uHorizontalLine);
            uGraphic.getParam().setStroke(new UStroke());
        } else if (c == '-') {
            uGraphic.draw(0.0, d, uHorizontalLine);
        } else {
            uGraphic.getParam().setStroke(new UStroke(1.5));
            uGraphic.draw(0.0, d, uHorizontalLine);
            uGraphic.getParam().setStroke(new UStroke());
        }
    }

    public static void drawLine(UGraphic uGraphic, double d, double d2, double d3, char c) {
        if (c == '=') {
            uGraphic.draw(d, d2, new ULine(d3, 0.0));
            uGraphic.draw(d, d2 + 2.0, new ULine(d3, 0.0));
        } else if (c == '.') {
            uGraphic.getParam().setStroke(new UStroke(1.0, 2.0, 1.0));
            uGraphic.draw(d, d2, new ULine(d3, 0.0));
            uGraphic.getParam().setStroke(new UStroke());
        } else if (c == '-') {
            uGraphic.draw(d, d2, new ULine(d3, 0.0));
        } else {
            uGraphic.getParam().setStroke(new UStroke(1.5));
            uGraphic.draw(d, d2, new ULine(d3, 0.0));
            uGraphic.getParam().setStroke(new UStroke());
        }
    }

    @Override
    public void drawU(UGraphic uGraphic, double d, double d2) {
        HtmlColor htmlColor = uGraphic.getParam().getColor();
        if (this.title == null) {
            TextBlockLineBefore2.drawLine(uGraphic, d2, UHorizontalLine.infinite(1.0, 1.0), this.separator);
        }
        this.textBlock.drawU(uGraphic, d, d2);
        uGraphic.getParam().setColor(htmlColor);
        if (this.title != null) {
            TextBlockLineBefore2.drawLine(uGraphic, d2, UHorizontalLine.infinite(1.0, 1.0, this.title), this.separator);
            uGraphic.getParam().setColor(htmlColor);
        }
    }

    @Override
    public List<Url> getUrls() {
        return this.textBlock.getUrls();
    }
}

