/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UGraphic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TextBlockMinWidth
implements TextBlock {
    private final TextBlock textBlock;
    private final double minWidth;
    private final HorizontalAlignement horizontalAlignement;

    public TextBlockMinWidth(TextBlock textBlock, double d, HorizontalAlignement horizontalAlignement) {
        this.textBlock = textBlock;
        this.minWidth = d;
        this.horizontalAlignement = horizontalAlignement;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.textBlock.calculateDimension(stringBounder);
        return Dimension2DDouble.atLeast(dimension2D, this.minWidth, 0.0);
    }

    @Override
    public void drawU(UGraphic uGraphic, double d, double d2) {
        if (this.horizontalAlignement == HorizontalAlignement.LEFT) {
            this.textBlock.drawU(uGraphic, d, d2);
        } else if (this.horizontalAlignement == HorizontalAlignement.RIGHT) {
            Dimension2D dimension2D = this.textBlock.calculateDimension(uGraphic.getStringBounder());
            double d3 = this.minWidth - dimension2D.getWidth();
            this.textBlock.drawU(uGraphic, d + d3, d2);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public List<Url> getUrls() {
        return this.textBlock.getUrls();
    }
}

