/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.SpriteContainer;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.CircledCharacter;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockHorizontal;
import net.sourceforge.plantuml.graphic.TextBlockMarged;
import net.sourceforge.plantuml.graphic.TextBlockMinWidth;
import net.sourceforge.plantuml.graphic.TextBlockSimple;
import net.sourceforge.plantuml.graphic.TextBlockSpotted;
import net.sourceforge.plantuml.graphic.TextBlockVertical2;
import net.sourceforge.plantuml.graphic.TextBlockWithNumber;
import net.sourceforge.plantuml.posimo.Positionable;
import net.sourceforge.plantuml.posimo.PositionableImpl;
import net.sourceforge.plantuml.sequencediagram.MessageNumber;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.ugraphic.UGraphic;

public class TextBlockUtils {
    public static TextBlock create(Display display, FontConfiguration fontConfiguration, HorizontalAlignement horizontalAlignement, SpriteContainer spriteContainer) {
        if (display.size() > 0) {
            if (display.get(0) instanceof Stereotype) {
                return TextBlockUtils.createStereotype(display, fontConfiguration, horizontalAlignement, spriteContainer, 0);
            }
            if (display.get(display.size() - 1) instanceof Stereotype) {
                return TextBlockUtils.createStereotype(display, fontConfiguration, horizontalAlignement, spriteContainer, display.size() - 1);
            }
            if (display.get(0) instanceof MessageNumber) {
                return TextBlockUtils.createMessageNumber(display, fontConfiguration, horizontalAlignement, spriteContainer);
            }
        }
        return new TextBlockSimple(display, fontConfiguration, horizontalAlignement, spriteContainer);
    }

    private static TextBlock createMessageNumber(Display display, FontConfiguration fontConfiguration, HorizontalAlignement horizontalAlignement, SpriteContainer spriteContainer) {
        MessageNumber messageNumber = (MessageNumber)display.get(0);
        return new TextBlockWithNumber(messageNumber.getNumber(), display.subList(1, display.size()), fontConfiguration, horizontalAlignement, spriteContainer);
    }

    private static TextBlock createStereotype(Display display, FontConfiguration fontConfiguration, HorizontalAlignement horizontalAlignement, SpriteContainer spriteContainer, int n) {
        Stereotype stereotype = (Stereotype)display.get(n);
        if (stereotype.isSpotted()) {
            CircledCharacter circledCharacter = new CircledCharacter(stereotype.getCharacter(), stereotype.getRadius(), stereotype.getCircledFont(), stereotype.getHtmlColor(), null, fontConfiguration.getColor());
            if (stereotype.getLabel() == null) {
                return new TextBlockSpotted(circledCharacter, display.subList(1, display.size()), fontConfiguration, horizontalAlignement, spriteContainer);
            }
            return new TextBlockSpotted(circledCharacter, display, fontConfiguration, horizontalAlignement, spriteContainer);
        }
        return new TextBlockSimple(display, fontConfiguration, horizontalAlignement, spriteContainer);
    }

    public static TextBlock withMargin(TextBlock textBlock, double d, double d2) {
        return new TextBlockMarged(textBlock, d, d, d2, d2);
    }

    public static TextBlock withMinWidth(TextBlock textBlock, double d, HorizontalAlignement horizontalAlignement) {
        return new TextBlockMinWidth(textBlock, d, horizontalAlignement);
    }

    public static TextBlock withMargin(TextBlock textBlock, double d, double d2, double d3, double d4) {
        return new TextBlockMarged(textBlock, d, d2, d3, d4);
    }

    public static TextBlock empty(final double d, final double d2) {
        return new TextBlock(){

            @Override
            public void drawU(UGraphic uGraphic, double d3, double d22) {
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble(d, d2);
            }

            @Override
            public List<Url> getUrls() {
                return Collections.emptyList();
            }
        };
    }

    public static Positionable asPositionable(TextBlock textBlock, StringBounder stringBounder, Point2D point2D) {
        return new PositionableImpl(point2D, textBlock.calculateDimension(stringBounder));
    }

    public static TextBlock fromIEntityImage(final IEntityImage iEntityImage) {
        return new TextBlock(){

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return iEntityImage.getDimension(stringBounder);
            }

            @Override
            public void drawU(UGraphic uGraphic, double d, double d2) {
                iEntityImage.drawU(uGraphic, d, d2);
            }

            @Override
            public List<Url> getUrls() {
                return Collections.emptyList();
            }
        };
    }

    public static TextBlock mergeLR(TextBlock textBlock, TextBlock textBlock2) {
        return new TextBlockHorizontal(textBlock, textBlock2);
    }

    public static TextBlock mergeTB(TextBlock textBlock, TextBlock textBlock2, HorizontalAlignement horizontalAlignement) {
        return new TextBlockVertical2(textBlock, textBlock2, horizontalAlignement);
    }
}

