/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TileText
implements TextBlock {
    private final String text;
    private final FontConfiguration fontConfiguration;
    private final Url url;

    public TileText(String string, FontConfiguration fontConfiguration, Url url) {
        this.fontConfiguration = fontConfiguration;
        this.text = string;
        this.url = url;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = stringBounder.calculateDimension(this.fontConfiguration.getFont(), this.text);
        int n = Math.abs(this.fontConfiguration.getSpace());
        Log.debug("g2d=" + dimension2D);
        Log.debug("Size for " + this.text + " is " + dimension2D);
        double d = dimension2D.getHeight();
        if (d < 10.0) {
            d = 10.0;
        }
        double d2 = this.text.indexOf(9) == -1 ? dimension2D.getWidth() : this.getWidth(stringBounder);
        return new Dimension2DDouble(d2, d + (double)n);
    }

    public double getFontSize2D() {
        return this.fontConfiguration.getFont().getSize2D();
    }

    double getTabSize(StringBounder stringBounder) {
        return stringBounder.calculateDimension(this.fontConfiguration.getFont(), "        ").getWidth();
    }

    @Override
    public void drawU(UGraphic uGraphic, double d, double d2) {
        if (this.url != null) {
            uGraphic.startUrl(this.url);
        }
        uGraphic.getParam().setColor(this.fontConfiguration.getColor());
        StringTokenizer stringTokenizer = new StringTokenizer(this.text, "\t", true);
        if (stringTokenizer.hasMoreTokens()) {
            double d3 = this.getTabSize(uGraphic.getStringBounder());
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                if (string.equals("\t")) {
                    double d4 = d % d3;
                    d += d3 - d4;
                    continue;
                }
                UText uText = new UText(string, this.fontConfiguration);
                Dimension2D dimension2D = uGraphic.getStringBounder().calculateDimension(this.fontConfiguration.getFont(), string);
                int n = this.fontConfiguration.getSpace();
                double d5 = n < 0 ? d2 + (double)n : d2 + (double)n;
                uGraphic.draw(d, d5, uText);
                d += dimension2D.getWidth();
            }
        }
        if (this.url != null) {
            uGraphic.closeAction();
        }
    }

    double getWidth(StringBounder stringBounder) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.text, "\t", true);
        double d = this.getTabSize(stringBounder);
        double d2 = 0.0;
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (string.equals("\t")) {
                double d3 = d2 % d;
                d2 += d - d3;
                continue;
            }
            Dimension2D dimension2D = stringBounder.calculateDimension(this.fontConfiguration.getFont(), string);
            d2 += dimension2D.getWidth();
        }
        return d2;
    }

    @Override
    public List<Url> getUrls() {
        if (this.url != null) {
            return Collections.singletonList(this.url);
        }
        return Collections.emptyList();
    }
}

